% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSmap.R
\name{MDSmap}
\alias{MDSmap}
\title{Multidimensional scaling (MDS) in 2 dimensions}
\usage{
MDSmap(data, std = TRUE)
}
\arguments{
\item{data}{a numeric matrix, data frame or \code{"dist"} object (see \code{\link[stats]{dist}}).}

\item{std}{logical; if TRUE, \code{data} columns are standardized (centered and scaled).}
}
\value{
An object of class \code{MDSmap}, i.e. a list with 4 objects:

\itemize{
\item \code{points}, a 2-column vector of the fitted configuration (see \code{\link[MASS]{isoMDS}});
}

\itemize{
\item \code{stress}, the final stress achieved in percent (see \code{\link[MASS]{isoMDS}});
}

\itemize{
\item \code{data}, the input data frame;
}

\itemize{
\item \code{std}, the logical \code{std} input.
}
}
\description{
Multidimensional scaling (MDS) in 2 dimensions
}
\details{
If \code{data} is an object of class \code{"dist"}, \code{std} is not active and \code{data} is directly inputted into \code{MASS::isoMDS}.
}
\examples{
data <- with(Pbox, data.frame(PTS, P3M, P2M, REB=OREB+DREB, AST, TOV, STL, BLK))
selp <- which(Pbox$MIN >= 1500)
data <- data[selp, ]
id <- Pbox$Player[selp]
mds <- MDSmap(data)
plot(mds, labels=id, z.var="P2M", level.plot=FALSE, palette=rainbow)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link[MASS]{isoMDS}}, \code{\link{plot.MDSmap}}.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
