% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{detect_cp_epi}
\alias{detect_cp_epi}
\title{Detect Change Points on a survival function}
\usage{
detect_cp_epi(
  data,
  n_iterations,
  q,
  M,
  xi,
  a0,
  b0,
  I0_var = 0.01,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a matrix where each row is a component of the time series and the columns correspond to the times.}

\item{n_iterations}{number of MCMC iterations.}

\item{q}{probability of performing a split at each iteration.}

\item{M}{number of Monte Carlo iterations when computing the likelihood of the survival function.}

\item{xi}{recovery rate fixed constant for each population at each time.}

\item{a0, b0}{parameters for the computation of the integrated likelihood of the survival functions.}

\item{I0_var}{variance for the Metropolis-Hastings estimation of the proportion of infected at time 0.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{detect_cp_epi} returns a list containing the following components: \itemize{
\item{\code{$orders}} a matrix where each row corresponds to the output order of the corresponding iteration.
\item{\code{time}} computational time in seconds.
\item{\code{$I0_MCMC}} traceplot for \eqn{I_0}.
\item{\code{$I0_MCMC_01}} a \eqn{0/1} vector, the \eqn{n}-th element is equal to \eqn{1} if the proposed \eqn{I_0} was accepted, \eqn{0} otherwise.
}
}
\description{
Detect Change Points on a survival function
}
\examples{
\donttest{
data_mat <- matrix(NA, nrow = 1, ncol = 100)

betas <- c(rep(0.45, 25),rep(0.14,75))

inf_times <- sim_epi_data(10000, 10, 100, betas, 1/8)

inf_times_vec <- rep(0,100)
names(inf_times_vec) <- as.character(1:100)

for(j in 1:100){
 if(as.character(j) \%in\% names(table(floor(inf_times)))){
 inf_times_vec[j] =
 table(floor(inf_times))[which(names(table(floor(inf_times))) == j)]}
}

data_mat[1,] <- inf_times_vec

out <- detect_cp_epi(data = data_mat, n_iterations = 250, q = 0.5,
                     xi = 1/8, a0 = 40, b0 = 10, M = 250)

}
}
