% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_BayesMassBal.R
\name{summary.BayesMassBal}
\alias{summary.BayesMassBal}
\title{Summary of BayesMassBal Object}
\usage{
\method{summary}{BayesMassBal}(object, export = NA, ...)
}
\arguments{
\item{object}{A \code{BayesMassBal} object returned from the \code{\link{BMB}} function}

\item{export}{Optional character string specifying location to save a \code{*.csv} file containing summary data.  Only data related to mass flow rates is printed.}

\item{...}{Additional arguments affecting the summary produced.  Not used for a \code{BayesMassBal} object.}
}
\value{
A summary table printed to the console, and optionally a saved \code{*.csv} file saved within the path as specified.
}
\description{
Prints a summary table containing mean values and 95% HPDI intervals for the mass flow rates, as well as the log-marginal likelihood for a \code{BayesMassBal} class object.  Options include trace plots, posterior densities, and main effects plots.
}
\details{
Current implementation only returns statistics for balanced mass flow rates, taken from \code{x$ybal}, and not statistics on \eqn{\beta} or variance parameters of \eqn{\sigma^2} and \eqn{\Sigma}.

The header entry of the table \code{95\% LB} should be interpreted as the lower bound of the 95% HPDI.  Similarly, the header entry of the table \code{95\% UB} should be interpreted as the upper bound of the 95% HPDI.
}
