% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMCMCdiag.R
\name{plotMCMCdiag}
\alias{plotMCMCdiag}
\title{show trace plots and diagnostic density plots}
\usage{
plotMCMCdiag(object, nbloc = 3, header = "", ...)
}
\arguments{
\item{object}{an object of class "BayesSUR"}

\item{nbloc}{number of splits for the last half iterations after substracting burn-in length}

\item{header}{the main title}

\item{...}{other arguments for the plots of the log-likelihood and model size}
}
\description{
Show trace plots and diagnostic density plots of a fitted model object of class "BayesSUR".
}
\examples{
data("example_eQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

fit <- BayesSUR(Y = example_eQTL[["blockList"]][[1]], 
                X = example_eQTL[["blockList"]][[2]],
                data = example_eQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 0, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check output
# show the diagnosis plots with at least 2000*(nbloc+1) iterations where nbloc=3 by default
\donttest{
plotMCMCdiag(fit)
}

}
