% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.BayesSUR.R
\name{coef.BayesSUR}
\alias{coef.BayesSUR}
\title{extract the posterior mean of the coefficients of a "BayesSUR" class object}
\usage{
\method{coef}{BayesSUR}(object, Pmax = 0, ...)
}
\arguments{
\item{object}{an object of class "BayesSUR"}

\item{Pmax}{threshold that truncates the estimated coefficients based on thresholding the estimated latent indicator variable. Default is 0.}

\item{...}{other arguments}
}
\value{
Estimated coefficients are from an object of class "BayesSUR". If the \code{BayesSUR} specified data standardization, the fitted values are base based on standardized data.
}
\description{
Extract the posterior mean of the coefficients of a "BayesSUR" class object
}
\examples{
data("example_eQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

fit <- BayesSUR(Y = example_eQTL[["blockList"]][[1]], 
                X = example_eQTL[["blockList"]][[2]],
                data = example_eQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check prediction
beta.hat <- coef(fit)

}
