% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_col_gradient.R
\name{ch_col_gradient}
\alias{ch_col_gradient}
\title{Creates a colour gradient}
\usage{
ch_col_gradient(
  x,
  colors = c("darkred", "red", "white", "blue", "darkblue"),
  colsteps = 100,
  climits = NULL
)
}
\arguments{
\item{x}{Vector of values used for gradient.}

\item{colors}{Vector of colours to form a gradient. Default is \code{`c("darkred", "red","white","blue", "darkblue")`}.}

\item{colsteps}{The number of steps in the gradient. Default is \code{100}.}

\item{climits}{Sets specific limits for common scaling.}
}
\value{
\item{res}{returned array of colour codes}
}
\description{
Creates a colour gradient for plotting.
}
\examples{
plot(rnorm(20),col='black')

# create a red blue colour gradient for plotting
mycol <- ch_col_gradient(rnorm(20), colsteps = 100)

# plot more random points in transparent blue colour
points(rnorm(20), col = mycol)
}
\author{
modified by Paul Whitfield
}
