% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{cms_translate}
\alias{cms_translate}
\title{Translate Python code or command line request to R list}
\usage{
cms_translate(text, ...)
}
\arguments{
\item{text}{The query code as copied from the Copernicus Marine
Service website. Both Python and command line code are accepted.
When this argument is omitted, the function will look for a query
on the system clipboard.}

\item{...}{Ignored}
}
\value{
Returns a named list with arguments for \code{cms_download_subset()}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Use the Copernicus Marine Service
website to navigate datasets
\url{https://data.marine.copernicus.eu/products}. You can specify
a query using the website's download form, and copy it's automation
download code (either command line or Python) to the system's clipboard.
You can then use this function to translate this code to a named list.
The list can be used in combination with \code{cms_download_subset()} to
download data. See \code{vignette("translate")} for more details.
}
\examples{
python_code <-
"import copernicusmarine

copernicusmarine.subset(
  dataset_id=\"cmems_mod_glo_phy_anfc_0.083deg_PT1H-m\",
  variables=[\"uo\",\"vo\"],
  minimum_longitude=-2,
  maximum_longitude=8,
  minimum_latitude=52,
  maximum_latitude=59,
  start_datetime=\"2025-01-01T00:00:00\",
  end_datetime=\"2025-01-01T23:00:00\",
  minimum_depth=0.49402499198913574,
  maximum_depth=0.49402499198913574,
)"

cli_code <-
"copernicusmarine subset
  --dataset-id cmems_mod_glo_phy_anfc_0.083deg_PT1H-m
  --variable uo
  --variable vo
  --start-datetime 2025-01-01T00:00:00
  --end-datetime 2025-01-01T23:00:00
  --minimum-longitude -2
  --maximum-longitude 8
  --minimum-latitude 52
  --maximum-latitude 59
  --minimum-depth 0.49402499198913574
  --maximum-depth 0.49402499198913574"

if (interactive() && requireNamespace("blosc")) {
  cms_translate(python_code)
  cms_translate(cli_code)
  translated <- cms_translate(cli_code)
  do.call(cms_download_subset, translated)
}
}
