% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.ClassificationOutput.R
\name{ClassificationOutput}
\alias{ClassificationOutput}
\title{D2MCS Classification Output.}
\description{
Allows computing the classification performance values achieved
by D2MCS. The class is automatically created when \code{\link{D2MCS}}
classification method is invoked.
}
\seealso{
\code{\link{D2MCS}}
}
\keyword{attribute}
\keyword{datagen}
\keyword{datasets}
\keyword{manip}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ClassificationOutput-new}{\code{ClassificationOutput$new()}}
\item \href{#method-ClassificationOutput-getMetrics}{\code{ClassificationOutput$getMetrics()}}
\item \href{#method-ClassificationOutput-getPositiveClass}{\code{ClassificationOutput$getPositiveClass()}}
\item \href{#method-ClassificationOutput-getModelInfo}{\code{ClassificationOutput$getModelInfo()}}
\item \href{#method-ClassificationOutput-getPerformances}{\code{ClassificationOutput$getPerformances()}}
\item \href{#method-ClassificationOutput-savePerformances}{\code{ClassificationOutput$savePerformances()}}
\item \href{#method-ClassificationOutput-plotPerformances}{\code{ClassificationOutput$plotPerformances()}}
\item \href{#method-ClassificationOutput-getPredictions}{\code{ClassificationOutput$getPredictions()}}
\item \href{#method-ClassificationOutput-savePredictions}{\code{ClassificationOutput$savePredictions()}}
\item \href{#method-ClassificationOutput-clone}{\code{ClassificationOutput$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-new"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$new(voting.schemes, models)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{voting.schemes}}{A \link{list} containing the voting schemes used
(inherited from \code{\link{VotingStrategy}}.}

\item{\code{models}}{A \link{list} containing the used \code{\link{Model}}
during classification stage.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-getMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-getMetrics}{}}}
\subsection{Method \code{getMetrics()}}{
The function returns the measures used during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$getMetrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector or \link{NULL} if training was not
performed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
The function gets the name of the positive class used for
training/classification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-getModelInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-getModelInfo}{}}}
\subsection{Method \code{getModelInfo()}}{
The function compiled all the information concerning to
the M.L. models used during training/classification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$getModelInfo(metrics = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metrics}}{A \link{character} vector defining the metrics used during
training/classification.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{list} with the information of each M.L. model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-getPerformances"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-getPerformances}{}}}
\subsection{Method \code{getPerformances()}}{
The function is used to compute the performance of D2MCS.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$getPerformances(
  test.set,
  measures,
  voting.names = NULL,
  metric.names = NULL,
  cutoff.values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{test.set}}{A \code{\link{Subset}} object used to compute the
performance.}

\item{\code{measures}}{A \link{character} vector with the measures to be used to
compute performance value (inherited from \code{\link{MeasureFunction}}).}

\item{\code{voting.names}}{A \link{character} vector with the name of the
voting schemes to analyze the performance. If not defined, all the voting
schemes used during classification stage will be taken into account.}

\item{\code{metric.names}}{A \link{character} containing the measures used
during training stage. If not defined, all training metrics used during
classification will be taken into account.}

\item{\code{cutoff.values}}{A \link{character} vector defining the minimum
probability used to perform a a positive classification. If is not
defined, all cutoffs used during classification stage will be taken into
account.}

\item{\code{dir.path}}{A \link{character} vector with location where the plot
will be saved.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{list} of performance values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-savePerformances"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-savePerformances}{}}}
\subsection{Method \code{savePerformances()}}{
The function is used to save the computed predictions into a
CSV file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$savePerformances(
  dir.path,
  test.set,
  measures,
  voting.names = NULL,
  metric.names = NULL,
  cutoff.values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{A \link{character} vector with location where the plot
will be saved.}

\item{\code{test.set}}{A \code{\link{Subset}} object used to compute the
performance.}

\item{\code{measures}}{A \link{character} vector with the measures to be used to
compute performance value (inherited from \code{\link{MeasureFunction}}).}

\item{\code{voting.names}}{A \link{character} vector with the name of the voting
schemes to analyze the performance. If not defined, all the voting
schemes used during classification stage will be taken into account.}

\item{\code{metric.names}}{A \link{character} containing the measures used
during training stage. If not defined, all training metrics used during
classification will be taken into account.}

\item{\code{cutoff.values}}{A \link{character} vector defining the minimum
probability used to perform a a positive classification. If is not
defined, all cutoffs used during classification stage will be taken into
account.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-plotPerformances"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-plotPerformances}{}}}
\subsection{Method \code{plotPerformances()}}{
The function allows to graphically visualize the computed
performance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$plotPerformances(
  dir.path,
  test.set,
  measures,
  voting.names = NULL,
  metric.names = NULL,
  cutoff.values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{A \link{character} vector with location where the plot
will be saved.}

\item{\code{test.set}}{A \code{\link{Subset}} object used to compute the
performance.}

\item{\code{measures}}{A \link{character} vector with the measures to be used to
compute performance value (inherited from \code{\link{MeasureFunction}}).}

\item{\code{voting.names}}{A \link{character} vector with the name of the voting
schemes to analyze the performance. If not defined, all the voting
schemes used during classification stage will be taken into account.}

\item{\code{metric.names}}{A \link{character} containing the measures used
during training stage. If not defined, all training metrics used during
classification will be taken into account.}

\item{\code{cutoff.values}}{A \link{character} vector defining the minimum
probability used to perform a positive classification. If is not defined,
all cutoffs used during classification stage will be taken into account.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-getPredictions"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-getPredictions}{}}}
\subsection{Method \code{getPredictions()}}{
The function is used to obtain the computed predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$getPredictions(
  voting.names = NULL,
  metric.names = NULL,
  cutoff.values = NULL,
  type = NULL,
  target = NULL,
  filter = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{voting.names}}{A \link{character} vector with the name of the voting
schemes to analyze the performance. If not defined, all the voting
schemes used during classification stage will be taken into account.}

\item{\code{metric.names}}{A \link{character} containing the measures used
during training stage. If not defined, all training metrics used during
classification will be taken into account.}

\item{\code{cutoff.values}}{A \link{character} vector defining the minimum
probability used to perform a a positive classification. If is not
defined, all cutoffs used during classification stage will be taken into
account.}

\item{\code{type}}{A \link{character} to define which type of predictions should
be returned. If not defined all type of probabilities will be returned.
Conversely if "prob" or "raw" is defined then computed 'probabilistic' or
'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the positive
class.}

\item{\code{filter}}{A \link{logical} value used to specify if only predictions
matching the target value should be returned or not. If \link{TRUE} the
function returns only the predictions matching the target value.
Conversely if \link{FALSE} (by default) the function returns all the
predictions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{PredictionOutput}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-savePredictions"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-savePredictions}{}}}
\subsection{Method \code{savePredictions()}}{
The function saves the predictions into a CSV file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$savePredictions(
  dir.path,
  voting.names = NULL,
  metric.names = NULL,
  cutoff.values = NULL,
  type = NULL,
  target = NULL,
  filter = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{A \link{character} vector with location defining the
location of the CSV file.}

\item{\code{voting.names}}{A \link{character} vector with the name of the
voting schemes to analyze the performance. If not defined, all the voting
schemes used during classification stage will be taken into account.}

\item{\code{metric.names}}{A \link{character} containing the measures used
during training stage. If not defined, all training metrics used during
classification will be taken into account.}

\item{\code{cutoff.values}}{A \link{character} vector defining the minimum
probability used to perform a positive classification. If is not defined,
all cutoffs used during classification stage will be taken into account.}

\item{\code{type}}{A \link{character} to define which type of predictions should
be returned. If not defined all type of probabilities will be returned.
Conversely if "prob" or "raw" is defined then computed 'probabilistic' or
'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the positive class.}

\item{\code{filter}}{A \link{logical} value used to specify if only predictions
matching the target value should be returned or not. If \link{TRUE} the
function returns only the predictions matching the target value.
Conversely if \link{FALSE} (by default) the function returns all the
predictions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClassificationOutput-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ClassificationOutput-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClassificationOutput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
