% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.heuristics.GenericHeuristic.R
\name{GenericHeuristic}
\alias{GenericHeuristic}
\title{Abstract Feature Clustering heuristic object.}
\description{
Abstract class used as a template to define new customized
clustering heuristics.
}
\details{
The \link{GenericHeuristic} is an archetype class so it cannot be
instantiated.
}
\seealso{
\code{\link{Dataset}}
}
\keyword{cluster}
\keyword{manip}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GenericHeuristic-new}{\code{GenericHeuristic$new()}}
\item \href{#method-GenericHeuristic-heuristic}{\code{GenericHeuristic$heuristic()}}
\item \href{#method-GenericHeuristic-clone}{\code{GenericHeuristic$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericHeuristic-new"></a>}}
\if{latex}{\out{\hypertarget{method-GenericHeuristic-new}{}}}
\subsection{Method \code{new()}}{
Empty function used to initialize the object arguments in
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericHeuristic$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericHeuristic-heuristic"></a>}}
\if{latex}{\out{\hypertarget{method-GenericHeuristic-heuristic}{}}}
\subsection{Method \code{heuristic()}}{
Function used to implement the clustering heuristic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericHeuristic$heuristic(col1, col2, column.names = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col1}}{A \link{numeric} vector or matrix required to perform the
clustering operation.}

\item{\code{col2}}{A \link{numeric} vector or matrix to perform the clustering
operation.}

\item{\code{column.names}}{An optional \link{character} vector with the names of
both columns}

\item{\code{...}}{Further arguments passed down to \code{heuristic} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GenericHeuristic-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GenericHeuristic-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericHeuristic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
