\name{possumsites}
\alias{possumsites}
\non_function{}
\title{Possum Sites}
\usage{data(possumsites)}
\description{
The \code{possumsites} data frame consists of latitudes, longitudes,
and altitudes for the seven sites from Southern Victoria to central Queensland
where the \code{possum} observations were made.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{latitude}{a numeric vector}
    \item{longitude}{a numeric vector}
    \item{altitude}{in meters}
  }
}
\source{
Lindenmayer, D. B., Viggers, K. L., Cunningham, R. B., and
Donnelly, C. F. 1995. Morphological variation among columns of the
mountain brushtail possum, Trichosurus caninus Ogilby
(Phalangeridae: Marsupiala). Australian Journal of Zoology 43:
449-458. 
}
\examples{
require(oz)
oz(sections=c(3:5, 11:16))
data(possumsites)
attach(possumsites)
points(latitude, longitude, pch=16, col=2)
chw <- par()$cxy[1]
chh <- par()$cxy[2]
posval <- c(2,4,2,2,4,2,2)
text(latitude+(3-posval)*chw/4, longitude, row.names(possumsites), pos=posval)
}
\keyword{datasets}
