\name{rockArt}
\alias{rockArt}
\docType{data}
\title{Pacific Rock Art features}
\description{
  Data characterise rock art at 103 sites in the Pacific.
}
\usage{rockArt}
\format{
  A data frame with 103 observations on the following 641 variables.
  \describe{
   \item{\code{Site.No.}}{a numeric vector}
    \item{\code{Site.Name}}{a character vector}
    \item{\code{Site.Code}}{a character vector}
    \item{\code{District}}{a character vector}
    \item{\code{Island}}{a character vector}
    \item{\code{Country}}{a character vector}
    \item{\code{Technique}}{a character vector}
    \item{\code{Engtech}}{a character vector}
    \item{\code{red}}{a numeric vector}
    \item{\code{black}}{a numeric vector}
    \item{\code{yellow}}{a numeric vector}
    \item{\code{white}}{a numeric vector}
    \item{\code{green}}{a numeric vector}
    \item{\code{red.blk}}{a numeric vector}
    \item{\code{red.wh}}{a numeric vector}
    \item{\code{red.yell}}{a numeric vector}
    \item{\code{r.w.y}}{a numeric vector}
    \item{\code{black.white}}{a numeric vector}
    \item{\code{blue}}{a numeric vector}
    \item{\code{Geology}}{a character vector}
    \item{\code{Topography}}{a character vector}
    \item{\code{Location}}{a character vector}
    \item{\code{Proxhab.km.}}{a character vector}
    \item{\code{Proxcoast.km.}}{a numeric vector}
    \item{\code{Maxheight.m.}}{a numeric vector}
    \item{\code{Language}}{a character vector}
    \item{\code{No.motif}}{a character vector}
    \item{\code{Ca1}}{a numeric vector}
    \item{\code{Ca2}}{a numeric vector}
    \item{\code{Ca3}}{a numeric vector}
    \item{\code{Ca4}}{a numeric vector}
    \item{\code{Cb5}}{a numeric vector}
    \item{\code{Cb6}}{a numeric vector}
    \item{\code{Cc7}}{a numeric vector}
    \item{\code{Cc8}}{a numeric vector}
    \item{\code{Cc9}}{a numeric vector}
    \item{\code{Cc10}}{a numeric vector}
    \item{\code{Cc11}}{a numeric vector}
    \item{\code{Cc12}}{a numeric vector}
    \item{\code{Cc13}}{a numeric vector}
    \item{\code{Cc14}}{a numeric vector}
    \item{\code{Cc15}}{a numeric vector}
    \item{\code{Cc16}}{a numeric vector}
    \item{\code{Cc17}}{a numeric vector}
    \item{\code{Cc18}}{a numeric vector}
    \item{\code{Cc19}}{a numeric vector}
    \item{\code{Cc20}}{a numeric vector}
    \item{\code{Cd21}}{a numeric vector}
    \item{\code{Cd22}}{a numeric vector}
    \item{\code{Cd23}}{a numeric vector}
    \item{\code{Cd24}}{a numeric vector}
    \item{\code{Cd25}}{a numeric vector}
    \item{\code{Cd26}}{a numeric vector}
    \item{\code{Cd27}}{a numeric vector}
    \item{\code{Ce28}}{a numeric vector}
    \item{\code{Ce29}}{a numeric vector}
    \item{\code{Cf30}}{a numeric vector}
    \item{\code{Cf31}}{a numeric vector}
    \item{\code{Cf32}}{a numeric vector}
    \item{\code{Cf33}}{a numeric vector}
    \item{\code{Cf34}}{a numeric vector}
    \item{\code{Cf35}}{a numeric vector}
    \item{\code{Cf36}}{a numeric vector}
    \item{\code{Cf37}}{a numeric vector}
    \item{\code{Cf38}}{a numeric vector}
    \item{\code{Cg39}}{a numeric vector}
    \item{\code{Cg40}}{a numeric vector}
    \item{\code{Ch41}}{a numeric vector}
    \item{\code{Ch42}}{a numeric vector}
    \item{\code{Ci43}}{a numeric vector}
    \item{\code{Ci44}}{a numeric vector}
    \item{\code{Cj45}}{a numeric vector}
    \item{\code{Ck46}}{a numeric vector}
    \item{\code{Ck47}}{a numeric vector}
    \item{\code{Cl48}}{a numeric vector}
    \item{\code{Cm49}}{a numeric vector}
    \item{\code{Cm50}}{a numeric vector}
    \item{\code{Cm51}}{a numeric vector}
    \item{\code{Cm52}}{a numeric vector}
    \item{\code{Cm53}}{a numeric vector}
    \item{\code{Cm54}}{a numeric vector}
    \item{\code{Cm55}}{a numeric vector}
    \item{\code{Cm56}}{a numeric vector}
    \item{\code{Cm57}}{a numeric vector}
    \item{\code{Cm58}}{a numeric vector}
    \item{\code{Cn59}}{a numeric vector}
    \item{\code{Cn60}}{a numeric vector}
    \item{\code{Cn61}}{a numeric vector}
    \item{\code{Cn62}}{a numeric vector}
    \item{\code{Cn63}}{a numeric vector}
    \item{\code{Cn64}}{a numeric vector}
    \item{\code{Cn65}}{a numeric vector}
    \item{\code{Cn66}}{a numeric vector}
    \item{\code{Cn67}}{a numeric vector}
    \item{\code{Cn68}}{a numeric vector}
    \item{\code{Cn69}}{a numeric vector}
    \item{\code{Cn70}}{a numeric vector}
    \item{\code{Cn71}}{a numeric vector}
    \item{\code{Co72}}{a numeric vector}
    \item{\code{Co73}}{a numeric vector}
    \item{\code{Co74}}{a numeric vector}
    \item{\code{Co75}}{a numeric vector}
    \item{\code{Co76}}{a numeric vector}
    \item{\code{Co77}}{a numeric vector}
    \item{\code{Co78}}{a numeric vector}
    \item{\code{Co79}}{a numeric vector}
    \item{\code{Cp80}}{a numeric vector}
    \item{\code{Cq81}}{a numeric vector}
    \item{\code{Cq82}}{a numeric vector}
    \item{\code{Cq83}}{a numeric vector}
    \item{\code{Cq84}}{a numeric vector}
    \item{\code{Cq85}}{a numeric vector}
    \item{\code{Cq86}}{a numeric vector}
    \item{\code{Cq87}}{a numeric vector}
    \item{\code{Cq88}}{a numeric vector}
    \item{\code{Cq89}}{a numeric vector}
    \item{\code{Cq90}}{a numeric vector}
    \item{\code{Cq91}}{a numeric vector}
    \item{\code{Cq92}}{a numeric vector}
    \item{\code{Cq93}}{a numeric vector}
    \item{\code{Cq94}}{a numeric vector}
    \item{\code{Cq95}}{a numeric vector}
    \item{\code{Cq96}}{a numeric vector}
    \item{\code{Cq97}}{a numeric vector}
    \item{\code{Cr98}}{a numeric vector}
    \item{\code{Cr99}}{a numeric vector}
    \item{\code{Cr100}}{a numeric vector}
    \item{\code{Cr101}}{a numeric vector}
    \item{\code{Cs102}}{a numeric vector}
    \item{\code{Cs103}}{a numeric vector}
    \item{\code{Cs104}}{a numeric vector}
    \item{\code{Cs105}}{a numeric vector}
    \item{\code{Cs106}}{a numeric vector}
    \item{\code{Ct107}}{a numeric vector}
    \item{\code{C108}}{a numeric vector}
    \item{\code{C109}}{a numeric vector}
    \item{\code{C110}}{a numeric vector}
    \item{\code{C111}}{a numeric vector}
    \item{\code{SSa1}}{a numeric vector}
    \item{\code{SSd2}}{a numeric vector}
    \item{\code{SSd3}}{a numeric vector}
    \item{\code{SSd4}}{a numeric vector}
    \item{\code{SSd5}}{a numeric vector}
    \item{\code{SSd6}}{a numeric vector}
    \item{\code{SSd7}}{a numeric vector}
    \item{\code{SSd8}}{a numeric vector}
    \item{\code{SSf9}}{a numeric vector}
    \item{\code{SSg10}}{a numeric vector}
    \item{\code{SSj11}}{a numeric vector}
    \item{\code{SSj12}}{a numeric vector}
    \item{\code{SSj13}}{a numeric vector}
    \item{\code{SSl14}}{a numeric vector}
    \item{\code{SSm15}}{a numeric vector}
    \item{\code{SSm16}}{a numeric vector}
    \item{\code{SSn17}}{a numeric vector}
    \item{\code{SSn18}}{a numeric vector}
    \item{\code{SSn19}}{a numeric vector}
    \item{\code{SSn20}}{a numeric vector}
    \item{\code{SSn21}}{a numeric vector}
    \item{\code{SSn22}}{a numeric vector}
    \item{\code{SSn23}}{a numeric vector}
    \item{\code{SSn24}}{a numeric vector}
    \item{\code{SSn25}}{a numeric vector}
    \item{\code{SSn26}}{a numeric vector}
    \item{\code{SSn27}}{a numeric vector}
    \item{\code{SSn28}}{a numeric vector}
    \item{\code{SSn29}}{a numeric vector}
    \item{\code{SSn30}}{a numeric vector}
    \item{\code{SSn31}}{a numeric vector}
    \item{\code{SSn32}}{a numeric vector}
    \item{\code{SSn33}}{a numeric vector}
    \item{\code{SSn34}}{a numeric vector}
    \item{\code{SSn35}}{a numeric vector}
    \item{\code{SSo36}}{a numeric vector}
    \item{\code{SSo37}}{a numeric vector}
    \item{\code{SSp38}}{a numeric vector}
    \item{\code{SSq39}}{a numeric vector}
    \item{\code{SSq40}}{a numeric vector}
    \item{\code{SSt41}}{a numeric vector}
    \item{\code{SSu42}}{a numeric vector}
    \item{\code{Oa1}}{a numeric vector}
    \item{\code{Oc2}}{a numeric vector}
    \item{\code{Od3}}{a numeric vector}
    \item{\code{Od4}}{a numeric vector}
    \item{\code{Oe5}}{a numeric vector}
    \item{\code{Of6}}{a numeric vector}
    \item{\code{Of7}}{a numeric vector}
    \item{\code{Of8}}{a numeric vector}
    \item{\code{Of9}}{a numeric vector}
    \item{\code{Og10}}{a numeric vector}
    \item{\code{Og11}}{a numeric vector}
    \item{\code{Og12}}{a numeric vector}
    \item{\code{Og13}}{a numeric vector}
    \item{\code{Og14}}{a numeric vector}
    \item{\code{Og15}}{a numeric vector}
    \item{\code{Oi16}}{a numeric vector}
    \item{\code{Om17}}{a numeric vector}
    \item{\code{Om18}}{a numeric vector}
    \item{\code{Om19}}{a numeric vector}
    \item{\code{Om20}}{a numeric vector}
    \item{\code{Om21}}{a numeric vector}
    \item{\code{On22}}{a numeric vector}
    \item{\code{On23}}{a numeric vector}
    \item{\code{On24}}{a numeric vector}
    \item{\code{Oq25}}{a numeric vector}
    \item{\code{Oq26}}{a numeric vector}
    \item{\code{Oq27}}{a numeric vector}
    \item{\code{.u28}}{a numeric vector}
    \item{\code{Ov29}}{a numeric vector}
    \item{\code{Ov30}}{a numeric vector}
    \item{\code{O31}}{a numeric vector}
    \item{\code{O32}}{a numeric vector}
    \item{\code{O33}}{a numeric vector}
    \item{\code{Sa1}}{a numeric vector}
    \item{\code{Sb2}}{a numeric vector}
    \item{\code{Sb3}}{a numeric vector}
    \item{\code{Sd4}}{a numeric vector}
    \item{\code{Sd5}}{a numeric vector}
    \item{\code{Sd6}}{a numeric vector}
    \item{\code{Sd7}}{a numeric vector}
    \item{\code{Se8}}{a numeric vector}
    \item{\code{Si9}}{a numeric vector}
    \item{\code{Sm10}}{a numeric vector}
    \item{\code{Sm11}}{a numeric vector}
    \item{\code{S12}}{a numeric vector}
    \item{\code{S13}}{a numeric vector}
    \item{\code{Sx14}}{a numeric vector}
    \item{\code{Sx15}}{a numeric vector}
    \item{\code{Sx16}}{a numeric vector}
    \item{\code{Sx17}}{a numeric vector}
    \item{\code{Sy18}}{a numeric vector}
    \item{\code{Sz19}}{a numeric vector}
    \item{\code{S20}}{a numeric vector}
    \item{\code{S21}}{a numeric vector}
    \item{\code{S22}}{a numeric vector}
    \item{\code{S23}}{a numeric vector}
    \item{\code{S24}}{a numeric vector}
    \item{\code{S25}}{a numeric vector}
    \item{\code{SCd1}}{a numeric vector}
    \item{\code{SCd2}}{a numeric vector}
    \item{\code{SCd3}}{a numeric vector}
    \item{\code{SCd4}}{a numeric vector}
    \item{\code{SCd5}}{a numeric vector}
    \item{\code{SCd6}}{a numeric vector}
    \item{\code{SCd7}}{a numeric vector}
    \item{\code{SCm8}}{a numeric vector}
    \item{\code{SCn9}}{a numeric vector}
    \item{\code{SCn10}}{a numeric vector}
    \item{\code{SCw11}}{a numeric vector}
    \item{\code{SCx12}}{a numeric vector}
    \item{\code{SCx13}}{a numeric vector}
    \item{\code{SCx14}}{a numeric vector}
    \item{\code{SCx15}}{a numeric vector}
    \item{\code{SCx16}}{a numeric vector}
    \item{\code{SCy17}}{a numeric vector}
    \item{\code{SCy18}}{a numeric vector}
    \item{\code{SC19}}{a numeric vector}
    \item{\code{SC20}}{a numeric vector}
    \item{\code{SC21}}{a numeric vector}
    \item{\code{SC22}}{a numeric vector}
    \item{\code{SC23}}{a numeric vector}
    \item{\code{SC24}}{a numeric vector}
    \item{\code{SC25}}{a numeric vector}
    \item{\code{SC26}}{a numeric vector}
    \item{\code{SRd1}}{a numeric vector}
    \item{\code{SRd2}}{a numeric vector}
    \item{\code{SRd3}}{a numeric vector}
    \item{\code{SRd4}}{a numeric vector}
    \item{\code{SRf5}}{a numeric vector}
    \item{\code{SRf6}}{a numeric vector}
    \item{\code{SRf7}}{a numeric vector}
    \item{\code{SRj8}}{a numeric vector}
    \item{\code{SR9}}{a numeric vector}
    \item{\code{SR10}}{a numeric vector}
    \item{\code{Bd1}}{a numeric vector}
    \item{\code{Bn2}}{a numeric vector}
    \item{\code{Bn3}}{a numeric vector}
    \item{\code{Bn4}}{a numeric vector}
    \item{\code{Bt5}}{a numeric vector}
    \item{\code{Bx6}}{a numeric vector}
    \item{\code{Ha1}}{a numeric vector}
    \item{\code{Hg2}}{a numeric vector}
    \item{\code{Hn3}}{a numeric vector}
    \item{\code{Hq4}}{a numeric vector}
    \item{\code{Hq5}}{a numeric vector}
    \item{\code{TDd1}}{a numeric vector}
    \item{\code{TDf2}}{a numeric vector}
    \item{\code{TDj3}}{a numeric vector}
    \item{\code{TDn4}}{a numeric vector}
    \item{\code{TDq5}}{a numeric vector}
    \item{\code{TD6}}{a numeric vector}
    \item{\code{TD7}}{a numeric vector}
    \item{\code{TD8}}{a numeric vector}
    \item{\code{TD9}}{a numeric vector}
    \item{\code{Dc1}}{a numeric vector}
    \item{\code{Dg2}}{a numeric vector}
    \item{\code{Dh3}}{a numeric vector}
    \item{\code{Dk4}}{a numeric vector}
    \item{\code{Dm5}}{a numeric vector}
    \item{\code{Dm6}}{a numeric vector}
    \item{\code{D7}}{a numeric vector}
    \item{\code{D8}}{a numeric vector}
    \item{\code{D9}}{a numeric vector}
    \item{\code{D10}}{a numeric vector}
    \item{\code{D11}}{a numeric vector}
    \item{\code{D12}}{a numeric vector}
    \item{\code{D13}}{a numeric vector}
    \item{\code{Ta1}}{a numeric vector}
    \item{\code{Tc2}}{a numeric vector}
    \item{\code{Tc3}}{a numeric vector}
    \item{\code{Tc4}}{a numeric vector}
    \item{\code{Td5}}{a numeric vector}
    \item{\code{Tf6}}{a numeric vector}
    \item{\code{Tf7}}{a numeric vector}
    \item{\code{Tg8}}{a numeric vector}
    \item{\code{Th9}}{a numeric vector}
    \item{\code{To10}}{a numeric vector}
    \item{\code{T11}}{a numeric vector}
    \item{\code{T12}}{a numeric vector}
    \item{\code{T13}}{a numeric vector}
    \item{\code{T14}}{a numeric vector}
    \item{\code{T15}}{a numeric vector}
    \item{\code{T16}}{a numeric vector}
    \item{\code{CNg1}}{a numeric vector}
    \item{\code{CN2}}{a numeric vector}
    \item{\code{CN3}}{a numeric vector}
    \item{\code{CN4}}{a numeric vector}
    \item{\code{CN5}}{a numeric vector}
    \item{\code{CN6}}{a numeric vector}
    \item{\code{CN7}}{a numeric vector}
    \item{\code{CN8}}{a numeric vector}
    \item{\code{Ld1}}{a numeric vector}
    \item{\code{Lf2}}{a numeric vector}
    \item{\code{Lg3}}{a numeric vector}
    \item{\code{Lp4}}{a numeric vector}
    \item{\code{L5}}{a numeric vector}
    \item{\code{L6}}{a numeric vector}
    \item{\code{L7}}{a numeric vector}
    \item{\code{L8}}{a numeric vector}
    \item{\code{L9}}{a numeric vector}
    \item{\code{L10}}{a numeric vector}
    \item{\code{L11}}{a numeric vector}
    \item{\code{LS1}}{a numeric vector}
    \item{\code{LS2}}{a numeric vector}
    \item{\code{LL1}}{a numeric vector}
    \item{\code{LL2}}{a numeric vector}
    \item{\code{LL3}}{a numeric vector}
    \item{\code{LL4}}{a numeric vector}
    \item{\code{LL5}}{a numeric vector}
    \item{\code{EGd1}}{a numeric vector}
    \item{\code{EGf2}}{a numeric vector}
    \item{\code{CCd1}}{a numeric vector}
    \item{\code{CCn2}}{a numeric vector}
    \item{\code{CCn3}}{a numeric vector}
    \item{\code{EMc1}}{a numeric vector}
    \item{\code{EMd2}}{a numeric vector}
    \item{\code{EMd3}}{a numeric vector}
    \item{\code{EMf4}}{a numeric vector}
    \item{\code{EMf5}}{a numeric vector}
    \item{\code{EMn6}}{a numeric vector}
    \item{\code{EMx7}}{a numeric vector}
    \item{\code{EM8}}{a numeric vector}
    \item{\code{EM9}}{a numeric vector}
    \item{\code{EM10}}{a numeric vector}
    \item{\code{EM11}}{a numeric vector}
    \item{\code{EM12}}{a numeric vector}
    \item{\code{TE1}}{a numeric vector}
    \item{\code{TE2}}{a numeric vector}
    \item{\code{TE3}}{a numeric vector}
    \item{\code{TE4}}{a numeric vector}
    \item{\code{TE5}}{a numeric vector}
    \item{\code{BWe1}}{a numeric vector}
    \item{\code{BWn2}}{a numeric vector}
    \item{\code{BWn3}}{a numeric vector}
    \item{\code{TS1}}{a numeric vector}
    \item{\code{TS2}}{a numeric vector}
    \item{\code{TS3}}{a numeric vector}
    \item{\code{TS4}}{a numeric vector}
    \item{\code{TS5}}{a numeric vector}
    \item{\code{TS6}}{a numeric vector}
    \item{\code{TS7}}{a numeric vector}
    \item{\code{TS8}}{a numeric vector}
    \item{\code{TS9}}{a numeric vector}
    \item{\code{Pg1}}{a numeric vector}
    \item{\code{Pg2}}{a numeric vector}
    \item{\code{Pg3}}{a numeric vector}
    \item{\code{DUaa1}}{a numeric vector}
    \item{\code{DUw2}}{a numeric vector}
    \item{\code{DU3}}{a numeric vector}
    \item{\code{CP1}}{a numeric vector}
    \item{\code{CP2}}{a numeric vector}
    \item{\code{CP3}}{a numeric vector}
    \item{\code{CP4}}{a numeric vector}
    \item{\code{CP5}}{a numeric vector}
    \item{\code{CP6}}{a numeric vector}
    \item{\code{CP7}}{a numeric vector}
    \item{\code{CP8}}{a numeric vector}
    \item{\code{CP9}}{a numeric vector}
    \item{\code{CP10}}{a numeric vector}
    \item{\code{CP11}}{a numeric vector}
    \item{\code{CP12}}{a numeric vector}
    \item{\code{STd1}}{a numeric vector}
    \item{\code{STd2}}{a numeric vector}
    \item{\code{STd3}}{a numeric vector}
    \item{\code{STg4}}{a numeric vector}
    \item{\code{STaa5}}{a numeric vector}
    \item{\code{STaa6}}{a numeric vector}
    \item{\code{STaa7}}{a numeric vector}
    \item{\code{STaa8}}{a numeric vector}
    \item{\code{ST9}}{a numeric vector}
    \item{\code{ST10}}{a numeric vector}
    \item{\code{ST11}}{a numeric vector}
    \item{\code{ST12}}{a numeric vector}
    \item{\code{Wd1}}{a numeric vector}
    \item{\code{Wd2}}{a numeric vector}
    \item{\code{Wd3}}{a numeric vector}
    \item{\code{Wd4}}{a numeric vector}
    \item{\code{Wn5}}{a numeric vector}
    \item{\code{Waa6}}{a numeric vector}
    \item{\code{Waa7}}{a numeric vector}
    \item{\code{W8}}{a numeric vector}
    \item{\code{W9}}{a numeric vector}
    \item{\code{W10}}{a numeric vector}
    \item{\code{W11}}{a numeric vector}
    \item{\code{W12}}{a numeric vector}
    \item{\code{W13}}{a numeric vector}
    \item{\code{Zd1}}{a numeric vector}
    \item{\code{Zd2}}{a numeric vector}
    \item{\code{Zn3}}{a numeric vector}
    \item{\code{Zw4}}{a numeric vector}
    \item{\code{Zw5}}{a numeric vector}
    \item{\code{Zaa6}}{a numeric vector}
    \item{\code{Z7}}{a numeric vector}
    \item{\code{Z8}}{a numeric vector}
    \item{\code{Z9}}{a numeric vector}
    \item{\code{Z10}}{a numeric vector}
    \item{\code{Z11}}{a numeric vector}
    \item{\code{Z12}}{a numeric vector}
    \item{\code{CLd1}}{a numeric vector}
    \item{\code{CLd2}}{a numeric vector}
    \item{\code{CLd3}}{a numeric vector}
    \item{\code{CLd4}}{a numeric vector}
    \item{\code{CLd5}}{a numeric vector}
    \item{\code{CLd6}}{a numeric vector}
    \item{\code{CLd7}}{a numeric vector}
    \item{\code{CLd8}}{a numeric vector}
    \item{\code{CLd9}}{a numeric vector}
    \item{\code{CLd10}}{a numeric vector}
    \item{\code{CLd11}}{a numeric vector}
    \item{\code{CLd12}}{a numeric vector}
    \item{\code{CLd13}}{a numeric vector}
    \item{\code{CLd14}}{a numeric vector}
    \item{\code{CLd15}}{a numeric vector}
    \item{\code{CLd16}}{a numeric vector}
    \item{\code{CLd17}}{a numeric vector}
    \item{\code{CLd18}}{a numeric vector}
    \item{\code{CLd19}}{a numeric vector}
    \item{\code{CLd20}}{a numeric vector}
    \item{\code{CLd21}}{a numeric vector}
    \item{\code{CLd22}}{a numeric vector}
    \item{\code{CLd23}}{a numeric vector}
    \item{\code{CLd24}}{a numeric vector}
    \item{\code{CLd25}}{a numeric vector}
    \item{\code{CLd26}}{a numeric vector}
    \item{\code{CLd27}}{a numeric vector}
    \item{\code{CLd28}}{a numeric vector}
    \item{\code{CLd29}}{a numeric vector}
    \item{\code{CLd30}}{a numeric vector}
    \item{\code{CLd31}}{a numeric vector}
    \item{\code{CLd32}}{a numeric vector}
    \item{\code{CLd33}}{a numeric vector}
    \item{\code{CLd34}}{a numeric vector}
    \item{\code{CLd35}}{a numeric vector}
    \item{\code{CLd36}}{a numeric vector}
    \item{\code{CLd37}}{a numeric vector}
    \item{\code{CLd38}}{a numeric vector}
    \item{\code{CLn39}}{a numeric vector}
    \item{\code{CLn40}}{a numeric vector}
    \item{\code{CLn41}}{a numeric vector}
    \item{\code{CLn42}}{a numeric vector}
    \item{\code{CLn43}}{a numeric vector}
    \item{\code{CLn44}}{a numeric vector}
    \item{\code{CLn45}}{a numeric vector}
    \item{\code{CLn46}}{a numeric vector}
    \item{\code{CLn47}}{a numeric vector}
    \item{\code{CLn48}}{a numeric vector}
    \item{\code{CLw49}}{a numeric vector}
    \item{\code{CL50}}{a numeric vector}
    \item{\code{CL51}}{a numeric vector}
    \item{\code{CL52}}{a numeric vector}
    \item{\code{CL53}}{a numeric vector}
    \item{\code{CL54}}{a numeric vector}
    \item{\code{CL55}}{a numeric vector}
    \item{\code{CL56}}{a numeric vector}
    \item{\code{CL57}}{a numeric vector}
    \item{\code{CL58}}{a numeric vector}
    \item{\code{CL59}}{a numeric vector}
    \item{\code{Xd1}}{a numeric vector}
    \item{\code{Xd2}}{a numeric vector}
    \item{\code{Xd3}}{a numeric vector}
    \item{\code{Xd4}}{a numeric vector}
    \item{\code{Xd5}}{a numeric vector}
    \item{\code{Xd6}}{a numeric vector}
    \item{\code{Xd7}}{a numeric vector}
    \item{\code{Xd8}}{a numeric vector}
    \item{\code{Xd9}}{a numeric vector}
    \item{\code{Xd10}}{a numeric vector}
    \item{\code{Xd11}}{a numeric vector}
    \item{\code{Xd12}}{a numeric vector}
    \item{\code{Xd13}}{a numeric vector}
    \item{\code{Xf14}}{a numeric vector}
    \item{\code{Xk15}}{a numeric vector}
    \item{\code{Xn16}}{a numeric vector}
    \item{\code{Xn17}}{a numeric vector}
    \item{\code{Xn18}}{a numeric vector}
    \item{\code{Xn19}}{a numeric vector}
    \item{\code{Xn20}}{a numeric vector}
    \item{\code{Xn21}}{a numeric vector}
    \item{\code{Xn22}}{a numeric vector}
    \item{\code{Xn23}}{a numeric vector}
    \item{\code{Xn24}}{a numeric vector}
    \item{\code{Xn25}}{a numeric vector}
    \item{\code{Xn26}}{a numeric vector}
    \item{\code{Xn27}}{a numeric vector}
    \item{\code{Xn28}}{a numeric vector}
    \item{\code{Xn29}}{a numeric vector}
    \item{\code{Xn30}}{a numeric vector}
    \item{\code{Xn31}}{a numeric vector}
    \item{\code{Xn32}}{a numeric vector}
    \item{\code{Xp33}}{a numeric vector}
    \item{\code{Xp34}}{a numeric vector}
    \item{\code{Xp35}}{a numeric vector}
    \item{\code{Xq36}}{a numeric vector}
    \item{\code{Xq37}}{a numeric vector}
    \item{\code{Xq38}}{a numeric vector}
    \item{\code{X39}}{a numeric vector}
    \item{\code{X40}}{a numeric vector}
    \item{\code{X41}}{a numeric vector}
    \item{\code{X42}}{a numeric vector}
    \item{\code{X43}}{a numeric vector}
    \item{\code{X44}}{a numeric vector}
    \item{\code{X45}}{a numeric vector}
    \item{\code{X46}}{a numeric vector}
    \item{\code{X47}}{a numeric vector}
    \item{\code{X48}}{a numeric vector}
    \item{\code{X49}}{a numeric vector}
    \item{\code{X50}}{a numeric vector}
    \item{\code{Qd1}}{a numeric vector}
    \item{\code{Qe2}}{a numeric vector}
    \item{\code{Qe3}}{a numeric vector}
    \item{\code{Qh4}}{a numeric vector}
    \item{\code{Qh5}}{a numeric vector}
    \item{\code{Qh6}}{a numeric vector}
    \item{\code{Qh7}}{a numeric vector}
    \item{\code{Qh8}}{a numeric vector}
    \item{\code{Qh9}}{a numeric vector}
    \item{\code{Qn10}}{a numeric vector}
    \item{\code{Qn11}}{a numeric vector}
    \item{\code{Qt12}}{a numeric vector}
    \item{\code{Q13}}{a numeric vector}
    \item{\code{Q14}}{a numeric vector}
    \item{\code{Q15}}{a numeric vector}
    \item{\code{Q16}}{a numeric vector}
    \item{\code{Q17}}{a numeric vector}
    \item{\code{Q18}}{a numeric vector}
    \item{\code{Q19}}{a numeric vector}
    \item{\code{Q20}}{a numeric vector}
    \item{\code{Q21}}{a numeric vector}
    \item{\code{Q22}}{a numeric vector}
    \item{\code{TZd1}}{a numeric vector}
    \item{\code{TZf2}}{a numeric vector}
    \item{\code{TZh3}}{a numeric vector}
    \item{\code{TZ4}}{a numeric vector}
    \item{\code{CRd1}}{a numeric vector}
    \item{\code{CR2}}{a numeric vector}
    \item{\code{CR3}}{a numeric vector}
    \item{\code{EUd1}}{a numeric vector}
    \item{\code{EUd2}}{a numeric vector}
    \item{\code{EUg3}}{a numeric vector}
    \item{\code{EUm4}}{a numeric vector}
    \item{\code{EUw5}}{a numeric vector}
    \item{\code{EU6}}{a numeric vector}
    \item{\code{Ud1}}{a numeric vector}
    \item{\code{Ud2}}{a numeric vector}
    \item{\code{Ud3}}{a numeric vector}
    \item{\code{Uaa4}}{a numeric vector}
    \item{\code{U5}}{a numeric vector}
    \item{\code{Vd1}}{a numeric vector}
    \item{\code{V2}}{a numeric vector}
    \item{\code{V3}}{a numeric vector}
    \item{\code{V4}}{a numeric vector}
    \item{\code{V5}}{a numeric vector}
    \item{\code{LWE1}}{a numeric vector}
    \item{\code{LWE2}}{a numeric vector}
    \item{\code{Ad1}}{a numeric vector}
    \item{\code{Al2}}{a numeric vector}
    \item{\code{Am3}}{a numeric vector}
    \item{\code{An4}}{a numeric vector}
    \item{\code{Aw5}}{a numeric vector}
    \item{\code{Aaa6}}{a numeric vector}
    \item{\code{A7}}{a numeric vector}
    \item{\code{A8}}{a numeric vector}
    \item{\code{A9}}{a numeric vector}
    \item{\code{EVd1}}{a numeric vector}
    \item{\code{EVg2}}{a numeric vector}
    \item{\code{TK1}}{a numeric vector}
    \item{\code{ECL1}}{a numeric vector}
    \item{\code{EFe1}}{a numeric vector}
    \item{\code{EFm2}}{a numeric vector}
    \item{\code{EFm3}}{a numeric vector}
    \item{\code{EF4}}{a numeric vector}
    \item{\code{LPo1}}{a numeric vector}
    \item{\code{LPq2}}{a numeric vector}
    \item{\code{LP3}}{a numeric vector}
    \item{\code{LP4}}{a numeric vector}
    \item{\code{LP5}}{a numeric vector}
    \item{\code{PT1}}{a numeric vector}
    \item{\code{CSC}}{a numeric vector}
    \item{\code{CSR}}{a numeric vector}
    \item{\code{CCRC}}{a numeric vector}
    \item{\code{SA}}{a numeric vector}
    \item{\code{Anthrop}}{a numeric vector}
    \item{\code{Turtle}}{a numeric vector}
    \item{\code{Boat}}{a numeric vector}
    \item{\code{Canoe}}{a numeric vector}
    \item{\code{Hand}}{a numeric vector}
    \item{\code{Foot}}{a numeric vector}
    \item{\code{Lizard}}{a numeric vector}
    \item{\code{Crocodile}}{a numeric vector}
    \item{\code{Jellyfish}}{a numeric vector}
    \item{\code{Bird}}{a numeric vector}
    \item{\code{Anthrobird}}{a numeric vector}
    \item{\code{Axe}}{a numeric vector}
    \item{\code{Marine}}{a numeric vector}
    \item{\code{Face}}{a numeric vector}
    \item{\code{Zoo1}}{a numeric vector}
    \item{\code{Zoo2}}{a numeric vector}
    \item{\code{Zoo3}}{a numeric vector}
    \item{\code{Zoo4}}{a numeric vector}
    \item{\code{Zoo5}}{a numeric vector}
    \item{\code{Zoo6}}{a numeric vector}
  }
}
\details{
Note the vignette \bold{rockArt}.
}
\source{
  Meredith Wilson: \emph{Picturing Pacific Pre-History} (PhD thesis), 2002,
  Australian National University.
}
\references{
 Meredith Wilson: Rethinking regional analyses of Western Pacific
 rock-art. \emph{Records of the Australian Museum}, Supplement 29: 173-186.
}
\examples{
data(rockArt)
rockart.dist <- dist(x = as.matrix(rockArt[, 28:641]), method = "binary")
sum(rockart.dist==1)/length(rockart.dist) 
plot(density(rockart.dist, to = 1))
rockart.cmd <- cmdscale(rockart.dist)
tab <- table(rockArt$District)
district <- as.character(rockArt$District)
district[!(rockArt$District \%in\% names(tab)[tab>5])] <- "other"
library(lattice)
\dontrun{
xyplot(rockart.cmd[,2] ~ rockart.cmd[,1], groups=district,
       auto.key=list(columns=5),
       par.settings=list(superpose.symbol=list(pch=16)))
library(MASS)
## For sammon, need to avoid zero distances
omit <- c(47, 54, 60, 63, 92)
rockart.dist <- dist(x = as.matrix(rockArt[-omit, 28:641]), method = "binary")
rockart.cmd <- cmdscale(rockart.dist)
rockart.sam <- sammon(rockart.dist, rockart.cmd)
xyplot(rockart.sam$points[,2] ~ rockart.sam$points[,1],
       groups=district[-omit], auto.key=list(columns=5),
       par.settings=list(superpose.symbol=list(pch=16)))
## Notice the very different appearance of the Sammon plot
}
}
\keyword{datasets}
