% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDiagnostics.R
\name{model_diagnostics_data}
\alias{model_diagnostics_data}
\title{Data preparation for regression diagnostics plots with pie-glyphs}
\usage{
model_diagnostics_data(model, prop = NULL)
}
\arguments{
\item{model}{A statistical regression model object fit using \code{lm},
\code{glm}, \code{nlme} functions, etc.}

\item{prop}{A character vector giving names of the compositional predictors
in the model. If this is not specified then plots prepared using
the data would not contain pie-glyphs.}
}
\value{
The original data used for fitting the model with the response and
        all model predictors along with the following additional columns
 \describe{
   \item{.hat}{Diagonal of the hat matrix.}
   \item{.sigma}{Estimate of residual standard deviation when corresponding observation is dropped from model.}
   \item{.cooksd}{The cook's distance (\code{\link[stats:cooks.distance]{cooks.distance()}}) for each observation.}
   \item{.fitted}{Fitted values of model.}
   \item{.resid}{The residuals for the observations.}
   \item{.stdresid}{The standardised (Pearson) residuals for the observations.}
   \item{Obs}{A unique identifier for each observation.}
   \item{Label}{The labels to be displayed besides the observations in the plot.}
   \item{.qq}{The quantile values for the standardised residuals generated using \code{\link[stats:qqnorm]{qqnorm()}}.}
   \item{weights}{The weights for each observation in the model (useful in the context of weighted regression).}
 }
}
\description{
This function prepares the data-frame with necessary attributes for creating
regression diagnostics plots for a model with compositional predictors where
points are replaced by pie-glyphs making it easier to track various data points
in the plots. The output data-frame can be passed to
\code{\link{model_diagnostics_plot}} to create the visualisation.
}
\examples{
library(DImodels)

## Load data
data(sim1)

## Fit model
mod1 <- lm(response ~ 0 + (p1 + p2 + p3 + p4)^2, data = sim1)

## Get data for diagnostics plot
diagnostics_data <- model_diagnostics_data(mod1,
                                           prop = c("p1", "p2", "p3", "p4"))
print(head(diagnostics_data))

## The compositional predictors in the data are added as attributes to the data
attr(diagnostics_data, "prop")
}
