% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMI.R
\name{IMI}
\alias{IMI}
\title{Improved Multiple Imputation (IMI) Estimation}
\usage{
IMI(d, M, midx, n)
}
\arguments{
\item{d}{\code{data.frame} containing the dependent variable (\code{Y}) and independent variables (\code{X}).}

\item{M}{Number of multiple imputations to perform.}

\item{midx}{Column indices of the missing variables in \code{d}.}

\item{n}{Vector of sample sizes for each group.}
}
\value{
A list containing the following elements:
\item{betahat}{Average regression coefficients across all imputations.}
\item{comm}{Indicator variable (0 for single group, 1 for multiple groups).}
}
\description{
This function performs Improved Multiple Imputation (IMI) estimation for grouped data with missing values.
It iteratively imputes missing values using the \code{LS} function and estimates regression coefficients using the \code{PPLS} function.
The final regression coefficients are averaged across multiple imputations.
}
\details{
The function assumes the data is grouped and contains missing values in specified columns (\code{midx}).
It uses the \code{LS} function to impute missing values and the \code{PPLS} function to estimate regression coefficients.
The process is repeated \code{M} times, and the final regression coefficients are averaged.
}
\examples{
# Example data

set.seed(123)
n <- c(300, 300, 400)  # Sample sizes for each group
p <- 5  # Number of independent variables
Y <- rnorm(sum(n))  # Dependent variable
X0 <- matrix(rnorm(sum(n) * p), ncol = p)  # Independent variables matrix
d <- list(p = p, Y = Y, X0 = X0)  # Data list
d$all <- cbind(Y, X0)
# Indices of missing variables (assuming some variables are missing)
midx <- c(2, 3)  # For example, the second and third variables are missing
# Call IMI function
result <- IMI(d, M = 5, midx = midx, n = n)
# View results
print(result$betahat)  # Average regression coefficients

}
