% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DYNATE.R
\name{DYNATE}
\alias{DYNATE}
\title{DYNATE
Function to conduct hierarchical mutiple testing based on the leaf p-values}
\usage{
DYNATE(struct_map, L = 5, alpha = 0.05)
}
\arguments{
\item{struct_map}{a data frame with both leaf information and P-value information.}

\item{L}{maximum number of layers}

\item{alpha}{desired FDR}
}
\value{
a data frame with testing results.
}
\description{
DYNATE
Function to conduct hierarchical mutiple testing based on the leaf p-values
}
\examples{
data("p_leaf")

# Set tuning parameters
L <- 3 # layer number
alpha <- 0.05 # desired FDR

# conduct dynamic and hierarchical testing based on the leaf level p values.
out <- DYNATE(struct_map=p_leaf,L=L,alpha=alpha)
summary(out)
}
\references{
Li, Xuechan, Anthony Sung, and Jichun Xie. "Distance Assisted Recursive Testing." arXiv preprint arXiv:2103.11085 (2021).
Pura, John, et al. "TEAM: A Multiple Testing Algorithm on the Aggregation Tree for Flow Cytometry Analysis." arXiv preprint arXiv:1906.07757 (2019).
}
