% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/channels.R
\name{color_channels}
\alias{color_channels}
\title{Identify the color for a channel based on palettes}
\usage{
color_channels(x, palette, mode = "dark")
}
\arguments{
\item{x}{Vector of \code{character} names of requested ECG or EGM leads}

\item{palette}{A \code{character} choice from the below options that describe the
color choices to be used for plotting. If set to the default, which is
\code{NULL}, no changes to the colors for individual channels will be performed.
If a positive choice is made, then the background \strong{mode} argument will be
set to \emph{dark} as the default, unless otherwise specified. \emph{WARNING}: This is
an experimental argument, and may be moved in future version.
\itemize{
\item \strong{NULL}: no changes to the colors will be made. DEFAULT.
\item \strong{material}: a colorscheme based off of the \href{https://m3.material.io/styles/color/system/how-the-system-works}{Material Design} color scheme
}}

\item{mode}{A \code{character} string from \code{c("dark", "light")} to describe the
base/background color settings to be used. If there are preset channel
colors that were exported in the \code{egm} object, these colors will be used
for the individual channels. If \strong{palette} is specified, then the \emph{dark}
option will be set automatically (a palette choice cannot be made without
understanding the background to plate it across). \emph{WARNING}: This is an
experimental argument, and may be moved in future version.
\itemize{
\item The \emph{dark} theme mimics the "white on black" scheme seen in \emph{LabSystem Pro} format (and most other high-contrast visualizations), for minimizing eye strain. This calls the \code{\link[=theme_egm_dark]{theme_egm_dark()}} function. DEFAULT.
\item The \emph{light} theme mimics the "black on white" colors seen in the \emph{Prucka} system.
\item \code{NULL} removes any theme, and uses the default \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} settings
}}
}
\value{
Vector of hex code colors as \code{character} based on the selected
palette and light/dark mode
}
\description{
This primarily restricts the colors to color-space safe options. It is
intended to be used with \code{\link[=add_colors]{add_colors()}} to provide a color scheme for the
\code{ggm} object. It has been exposed to users for custom or advanced theming
options.
}
