% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFunctions.R
\name{recombinationMatrix}
\alias{recombinationMatrix}
\title{Recombination matrix generation}
\usage{
recombinationMatrix(genomeObj)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}
}
\value{
A recombination matrix (probability matrix which associates to each
genotype in a row the probability of recombining or not and of becoming
another genotype or remaining the same).
}
\description{
Generation of the recombination matrix associated to a \code{Genome} object.
}
\details{
A recombination matrix is a square matrix of size equal to the number of
genotypes. It is a probability matrix in that the sum of the values in each
row is equal to 1. For a given genotype, the row associated with it
describes the probabilistic proportions that lead by recombination
between diploid loci to the production of the other genotypes (and of
itself if there are no mutations).
}
\author{
Ehouarn Le Faou
}
