% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nearest_point.R
\name{get_nearest_point}
\alias{get_nearest_point}
\title{Search the nearest point in a data frame}
\usage{
get_nearest_point(lon, lat, pointDf)
}
\arguments{
\item{lon}{Longitude of a point (in degrees; WGS 84). One value, data type "numeric" from -180 until 180 and finite.}

\item{lat}{Latitude of a point (in degrees; WGS 84). One value, data type "numeric" from -90 until 90 and finite.}

\item{pointDf}{Data frame that contains coordinates (WGS 84) of points above the treeline.
The first column must contain the longitude, the second the latitude.
The values must be of the data type "numeric" and finite.}
}
\value{
A list containing the longitude and the latitude of the nearest point.
}
\description{
Search for the nearest point in a data frame using a k-dimensional tree and a nearest neighbor search.
The aim of this function is to get the nearest point above the treeline given the chosen \code{lon} and \code{lat}.
}
\examples{
#Create a dummy data frame.
longitude <- seq(0, 10)
latitude <- seq(40, 50)
temp <- data.frame(longitude, latitude)
get_nearest_point(lon = 8.65, lat = 46.87, pointDf = temp)

#Use the data that is included in the package.
get_nearest_point(lon = 8.65, lat = 46.87, pointDf = pointsAboveTreeline)
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
