% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bachelier_impvol.R
\name{BachelierImpvol}
\alias{BachelierImpvol}
\title{Calculate Bachelier model implied volatility}
\usage{
BachelierImpvol(
  price,
  strike = forward,
  spot,
  texp = 1,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{price}{(vector of) option price}

\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
Bachelier implied volatility
}
\description{
Calculate Bachelier model implied volatility
}
\examples{
spot <- 100
strike <- 100
texp <- 1.2
sigma <- 20
intr <- 0.05
price <- 20
FER::BachelierImpvol(price, strike, spot, texp, intr=intr)

}
\references{
Choi, J., Kim, K., & Kwak, M. (2009).
  Numerical Approximation of the Implied Volatility Under Arithmetic Brownian
  Motion. Applied Mathematical Finance, 16(3), 261-268.
  \doi{10.1080/13504860802583436}
}
\seealso{
\code{\link{BachelierPrice}}
}
