% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lfreg.R
\name{plot_lfreg}
\alias{plot_lfreg}
\title{Plot coefficients from LFREG model}
\usage{
plot_lfreg(object)
}
\arguments{
\item{object}{LFREG model}
}
\value{
plot of the beta coefficient regression functions for each variable
}
\description{
Plot coefficients from LFREG model
}
\examples{
library(fda)
precipitation_data = CanadianWeather$daily[1:334,,"Precipitation.mm"]
annualprec = apply(precipitation_data,2,sum) # without December
y = ifelse(annualprec<mean(annualprec), 0, 1)
y = as.factor(y)
x = CanadianWeather$daily[1:334,,"Temperature.C"]
xbasis = create.fourier.basis(c(1,334),5) # 5 basis functions
xfd = smooth.basis(c(1:334),x,xbasis)$fd
bbasis = create.fourier.basis(c(0,334),5)
betalist = list(bbasis)
formula = y ~ xfd
lfreg.model = lfreg(formula, betalist = betalist)
plot_lfreg(lfreg.model)

}
