% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{huber.mean}
\alias{huber.mean}
\title{Tuning-free Huber mean estimation}
\usage{
huber.mean(X)
}
\arguments{
\item{X}{An \eqn{n}-dimensional data vector.}
}
\value{
A Huber mean estimator will be returned.
}
\description{
The function calculates adaptive Huber mean estimator from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\examples{
n = 10000
X = rt(n, 2) + 2
mu = huber.mean(X)
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Wang, L., Zheng, C., Zhou, W. and Zhou, W.-X. (2020). A New Principle for Tuning-Free Huber Regression. Stat. Sin., to appear.
}
\seealso{
\code{\link{huber.cov}} for tuning-free Huber-type covariance estimation and \code{\link{huber.reg}} for tuning-free Huber regression.
}
