// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_Multinomial_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 49> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 17, column 1 to column 19)",
  " (in 'string', line 18, column 1 to column 19)",
  " (in 'string', line 22, column 1 to column 25)",
  " (in 'string', line 23, column 1 to column 25)",
  " (in 'string', line 26, column 1 to column 15)",
  " (in 'string', line 52, column 1 to column 19)",
  " (in 'string', line 27, column 1 to column 25)",
  " (in 'string', line 28, column 1 to column 25)",
  " (in 'string', line 30, column 3 to column 43)",
  " (in 'string', line 31, column 3 to column 43)",
  " (in 'string', line 32, column 3 to column 37)",
  " (in 'string', line 29, column 14 to line 33, column 2)",
  " (in 'string', line 29, column 1 to line 33, column 2)",
  " (in 'string', line 55, column 2 to column 58)",
  " (in 'string', line 53, column 14 to line 56, column 2)",
  " (in 'string', line 53, column 1 to line 56, column 2)",
  " (in 'string', line 40, column 2 to column 40)",
  " (in 'string', line 39, column 7 to line 40, column 40)",
  " (in 'string', line 38, column 2 to column 40)",
  " (in 'string', line 37, column 2 to line 40, column 40)",
  " (in 'string', line 44, column 2 to column 40)",
  " (in 'string', line 43, column 7 to line 44, column 40)",
  " (in 'string', line 42, column 2 to column 40)",
  " (in 'string', line 41, column 2 to line 44, column 40)",
  " (in 'string', line 48, column 2 to column 40)",
  " (in 'string', line 46, column 16 to line 49, column 2)",
  " (in 'string', line 46, column 1 to line 49, column 2)",
  " (in 'string', line 2, column 1 to column 16)",
  " (in 'string', line 5, column 1 to column 17)",
  " (in 'string', line 6, column 1 to column 17)",
  " (in 'string', line 7, column 8 to column 9)",
  " (in 'string', line 7, column 10 to column 12)",
  " (in 'string', line 7, column 1 to column 17)",
  " (in 'string', line 8, column 8 to column 9)",
  " (in 'string', line 8, column 10 to column 12)",
  " (in 'string', line 8, column 1 to column 17)",
  " (in 'string', line 10, column 7 to column 8)",
  " (in 'string', line 10, column 1 to column 12)",
  " (in 'string', line 11, column 1 to column 24)",
  " (in 'string', line 12, column 1 to column 24)",
  " (in 'string', line 13, column 1 to column 32)",
  " (in 'string', line 14, column 1 to column 32)",
  " (in 'string', line 17, column 8 to column 10)",
  " (in 'string', line 18, column 8 to column 10)",
  " (in 'string', line 22, column 17 to column 18)",
  " (in 'string', line 23, column 17 to column 18)",
  " (in 'string', line 26, column 8 to column 9)",
  " (in 'string', line 52, column 8 to column 9)"};
#include <stan_meta_header.hpp>
class model_Multinomial final : public model_base_crtp<model_Multinomial> {
private:
  int N;
  int K0;
  int K1;
  Eigen::Matrix<double,-1,-1> X0_data__;
  Eigen::Matrix<double,-1,-1> X1_data__;
  std::vector<std::vector<int>> Y;
  double hyperprior_omega1;
  double hyperprior_omega0;
  int link_prior_omega1;
  int link_prior_omega0;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X0{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X1{nullptr, 0, 0};
public:
  ~model_Multinomial() {}
  model_Multinomial(stan::io::var_context& context__, unsigned int
                    random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_Multinomial_namespace::model_Multinomial";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 28;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 28;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "K0", "int",
        std::vector<size_t>{});
      K0 = std::numeric_limits<int>::min();
      current_statement__ = 29;
      K0 = context__.vals_i("K0")[(1 - 1)];
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "K0", K0, 1);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "K1", "int",
        std::vector<size_t>{});
      K1 = std::numeric_limits<int>::min();
      current_statement__ = 30;
      K1 = context__.vals_i("K1")[(1 - 1)];
      current_statement__ = 30;
      stan::math::check_greater_or_equal(function__, "K1", K1, 1);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("X0", "N", N);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("X0", "K0", K0);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "X0", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K0)});
      X0_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K0,
                    std::numeric_limits<double>::quiet_NaN());
      new (&X0) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X0_data__.data(), N,
        K0);
      {
        std::vector<local_scalar_t__> X0_flat__;
        current_statement__ = 33;
        X0_flat__ = context__.vals_r("X0");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
          current_statement__ = 33;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 33;
            stan::model::assign(X0, X0_flat__[(pos__ - 1)],
              "assigning variable X0", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 33;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 34;
      stan::math::validate_non_negative_index("X1", "N", N);
      current_statement__ = 35;
      stan::math::validate_non_negative_index("X1", "K1", K1);
      current_statement__ = 36;
      context__.validate_dims("data initialization", "X1", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K1)});
      X1_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K1,
                    std::numeric_limits<double>::quiet_NaN());
      new (&X1) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X1_data__.data(), N,
        K1);
      {
        std::vector<local_scalar_t__> X1_flat__;
        current_statement__ = 36;
        X1_flat__ = context__.vals_r("X1");
        current_statement__ = 36;
        pos__ = 1;
        current_statement__ = 36;
        for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
          current_statement__ = 36;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 36;
            stan::model::assign(X1, X1_flat__[(pos__ - 1)],
              "assigning variable X1", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 36;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 37;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "Y", "int",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(3)});
      Y = std::vector<std::vector<int>>(N,
            std::vector<int>(3, std::numeric_limits<int>::min()));
      {
        std::vector<int> Y_flat__;
        current_statement__ = 38;
        Y_flat__ = context__.vals_i("Y");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 38;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 38;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 38;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 39;
      context__.validate_dims("data initialization", "hyperprior_omega1",
        "double", std::vector<size_t>{});
      hyperprior_omega1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 39;
      hyperprior_omega1 = context__.vals_r("hyperprior_omega1")[(1 - 1)];
      current_statement__ = 40;
      context__.validate_dims("data initialization", "hyperprior_omega0",
        "double", std::vector<size_t>{});
      hyperprior_omega0 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      hyperprior_omega0 = context__.vals_r("hyperprior_omega0")[(1 - 1)];
      current_statement__ = 41;
      context__.validate_dims("data initialization", "link_prior_omega1",
        "int", std::vector<size_t>{});
      link_prior_omega1 = std::numeric_limits<int>::min();
      current_statement__ = 41;
      link_prior_omega1 = context__.vals_i("link_prior_omega1")[(1 - 1)];
      current_statement__ = 41;
      stan::math::check_greater_or_equal(function__, "link_prior_omega1",
        link_prior_omega1, 1);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "link_prior_omega0",
        "int", std::vector<size_t>{});
      link_prior_omega0 = std::numeric_limits<int>::min();
      current_statement__ = 42;
      link_prior_omega0 = context__.vals_i("link_prior_omega0")[(1 - 1)];
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "link_prior_omega0",
        link_prior_omega0, 1);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("omega0", "K0", K0);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("omega1", "K1", K1);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("reg1", "N", N);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("reg0", "N", N);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("q", "N", N);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = K0 + K1;
  }
  inline std::string model_name() const final {
    return "model_Multinomial";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_Multinomial_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> omega0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K0, DUMMY_VAR__);
      current_statement__ = 1;
      omega0 = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K0);
      Eigen::Matrix<local_scalar_t__,-1,1> omega1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K1, DUMMY_VAR__);
      current_statement__ = 2;
      omega1 = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K1);
      Eigen::Matrix<local_scalar_t__,-1,1> reg1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> reg0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> q =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 3, DUMMY_VAR__);
      current_statement__ = 7;
      stan::model::assign(reg1,
        stan::math::exp(stan::math::multiply(X1, omega1)),
        "assigning variable reg1");
      current_statement__ = 8;
      stan::model::assign(reg0,
        stan::math::exp(stan::math::multiply(X0, omega0)),
        "assigning variable reg0");
      current_statement__ = 13;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 9;
        stan::model::assign(q,
          (stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)) / ((1
          + stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 10;
        stan::model::assign(q,
          (stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i)) / ((1
          + stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(2));
        current_statement__ = 11;
        stan::model::assign(q, (1 / ((1 +
          stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(3));
      }
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "reg1", reg1, 0);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "reg0", reg0, 0);
      {
        current_statement__ = 20;
        if (stan::math::logical_eq(link_prior_omega1, 1)) {
          current_statement__ = 19;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(omega1, 0,
                           hyperprior_omega1));
        } else {
          current_statement__ = 18;
          if (stan::math::logical_eq(link_prior_omega1, 2)) {
            current_statement__ = 17;
            lp_accum__.add(stan::math::cauchy_lpdf<propto__>(omega1, 0,
                             hyperprior_omega1));
          }
        }
        current_statement__ = 24;
        if (stan::math::logical_eq(link_prior_omega0, 1)) {
          current_statement__ = 23;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(omega0, 0,
                           hyperprior_omega0));
        } else {
          current_statement__ = 22;
          if (stan::math::logical_eq(link_prior_omega0, 2)) {
            current_statement__ = 21;
            lp_accum__.add(stan::math::cauchy_lpdf<propto__>(omega0, 0,
                             hyperprior_omega0));
          }
        }
        current_statement__ = 27;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 25;
          lp_accum__.add(stan::math::multinomial_lpmf<propto__>(
                           stan::model::rvalue(Y, "Y",
                             stan::model::index_uni(n),
                             stan::model::index_omni()),
                           stan::math::transpose(
                             stan::model::rvalue(q, "q",
                               stan::model::index_uni(n),
                               stan::model::index_omni()))));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_Multinomial_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> omega0 =
        Eigen::Matrix<double,-1,1>::Constant(K0,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      omega0 = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K0);
      Eigen::Matrix<double,-1,1> omega1 =
        Eigen::Matrix<double,-1,1>::Constant(K1,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      omega1 = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K1);
      Eigen::Matrix<double,-1,1> reg1 =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> reg0 =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> q =
        Eigen::Matrix<double,-1,-1>::Constant(N, 3,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(omega0);
      out__.write(omega1);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 7;
      stan::model::assign(reg1,
        stan::math::exp(stan::math::multiply(X1, omega1)),
        "assigning variable reg1");
      current_statement__ = 8;
      stan::model::assign(reg0,
        stan::math::exp(stan::math::multiply(X0, omega0)),
        "assigning variable reg0");
      current_statement__ = 13;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 9;
        stan::model::assign(q,
          (stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)) / ((1
          + stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 10;
        stan::model::assign(q,
          (stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i)) / ((1
          + stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(2));
        current_statement__ = 11;
        stan::model::assign(q, (1 / ((1 +
          stan::model::rvalue(reg1, "reg1", stan::model::index_uni(i))) +
          stan::model::rvalue(reg0, "reg0", stan::model::index_uni(i)))),
          "assigning variable q", stan::model::index_uni(i),
          stan::model::index_uni(3));
      }
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "reg1", reg1, 0);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "reg0", reg0, 0);
      if (emit_transformed_parameters__) {
        out__.write(reg1);
        out__.write(reg0);
        out__.write(q);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 16;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 14;
        stan::model::assign(log_lik,
          stan::math::multinomial_lpmf<false>(
            stan::model::rvalue(Y, "Y", stan::model::index_uni(n),
              stan::model::index_omni()),
            stan::math::transpose(
              stan::model::rvalue(q, "q", stan::model::index_uni(n),
                stan::model::index_omni()))), "assigning variable log_lik",
          stan::model::index_uni(n));
      }
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> omega0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K0, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(omega0,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K0),
        "assigning variable omega0");
      out__.write(omega0);
      Eigen::Matrix<local_scalar_t__,-1,1> omega1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K1, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(omega1,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K1),
        "assigning variable omega1");
      out__.write(omega1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "omega0", "double",
        std::vector<size_t>{static_cast<size_t>(K0)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "omega1", "double",
        std::vector<size_t>{static_cast<size_t>(K1)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> omega0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K0, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> omega0_flat__;
        current_statement__ = 1;
        omega0_flat__ = context__.vals_r("omega0");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(omega0, omega0_flat__[(pos__ - 1)],
            "assigning variable omega0", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(omega0);
      Eigen::Matrix<local_scalar_t__,-1,1> omega1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K1, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> omega1_flat__;
        current_statement__ = 2;
        omega1_flat__ = context__.vals_r("omega1");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(omega1, omega1_flat__[(pos__ - 1)],
            "assigning variable omega1", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(omega1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"omega0", "omega1"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"reg1", "reg0", "q"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    K0)},
                std::vector<size_t>{static_cast<size_t>(K1)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(3)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
      param_names__.emplace_back(std::string() + "omega0" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
      param_names__.emplace_back(std::string() + "omega1" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "reg1" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "reg0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "q" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
      param_names__.emplace_back(std::string() + "omega0" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
      param_names__.emplace_back(std::string() + "omega1" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "reg1" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "reg0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "q" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"omega0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K0) + "},\"block\":\"parameters\"},{\"name\":\"omega1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K1) + "},\"block\":\"parameters\"},{\"name\":\"reg1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"reg0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(3) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"omega0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K0) + "},\"block\":\"parameters\"},{\"name\":\"omega1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K1) + "},\"block\":\"parameters\"},{\"name\":\"reg1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"reg0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(3) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (K0 + K1);
    const size_t num_transformed = emit_transformed_parameters * (((N + N) +
      (N * 3)));
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (K0 + K1);
    const size_t num_transformed = emit_transformed_parameters * (((N + N) +
      (N * 3)));
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_Multinomial_namespace::model_Multinomial;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Multinomial_namespace::profiles__;
}
#endif
#endif
