% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSphere.R
\name{plotSphere}
\alias{plotSphere}
\title{Plot an 3D sequence with sedentary sphere}
\usage{
plotSphere(x, start = 0, end = 1, length = NULL,
  time.format = "auto", density = FALSE, col, alpha, arrow = TRUE,
  levels, add = FALSE, ...)
}
\arguments{
\item{x}{The AccData input to be plotted}

\item{start}{start time to enter in the format 0 to 1 or "dd hh:mm:ss"}

\item{end}{end time to enter in the format 0 to 1 or "dd hh:mm:ss"}

\item{length}{Length of interval.}

\item{time.format}{Data extraction via get.intervals}

\item{density}{Whether to plot a  3d density plot.}

\item{col}{Colours to use for lines or density plot}

\item{alpha}{Vector of transparencies to user for density plot}

\item{arrow}{To display a place holder arrow to establish directionality}

\item{levels}{Breakpoints for plotting of isospheres for density. Follows the formulation of 0.9 == respective isosphere contains the highest probability 10 of the population, according to kernel density estimate.}

\item{add}{If draw, superimpose on to existing plot. Else add to a new plot.}

\item{...}{Arguements that will be passed to the}
}
\value{
There is no return to the console. As a side effect an rgl graphic is created.
}
\description{
From the output of the read.bin function in GENEAread to simulate data and create a spherical representation.
}
\details{
Takes the raw data output of the GENEActiv as AccData to plot points on the sedentary sphere.
}
\examples{
\dontrun{
x = readRDS(system.file("extdata", "AccData.rds", package = "GENEAsphere"))
plotSphere(x)}
}
