% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_network_statistics.R
\name{calculate_network_statistics}
\alias{calculate_network_statistics}
\title{A Function to estimate calculate (weighted) network statistics}
\usage{
calculate_network_statistics(network, weights = NULL,
  downweight_statistics_together = TRUE)
}
\arguments{
\item{network}{A square numeric matrix (sociomatrix or adjacency matrix)
representing the network.}

\item{weights}{If you wish to provide your own weights, you must provide a
vector of length 6 with terms corresponding to out2stars, in2stars, ctriads,
mutual, ttriads, edges in that order.}

\item{downweight_statistics_together}{Logical indicating whether exponential
down weighting should be done together or separately. Defaults to TRUE.}
}
\value{
A gergm object containing parameter estimates.
}
\description{
Calculates out2stars, in2stars, ctriads, mutual, ttriads, and
edges statistics (with or without exponential down weighting) for a
real-valued network.
}
