% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossbasis_inla.R
\name{crossbasis_inla}
\alias{crossbasis_inla}
\title{Create a Two-Dimensional INLA-compatible Cross-basis Matrix}
\usage{
crossbasis_inla(
  covariate,
  basis_name,
  lag,
  argvar = list(),
  arglag = list(),
  ...
)
}
\arguments{
\item{covariate}{A numeric matrix of covariate values. Typically this will be a
matrix of lagged covariate values (which can be generated using \code{\link{lag_cov}}).}

\item{basis_name}{A character string specifying the prefix for the spline columns
in the resulting basis matrix (replacing the default \code{"v"}).}

\item{lag}{A numeric vector with min and max lag of the matrix (as in \code{\link[dlnm]{crossbasis}}).}

\item{argvar}{A list specifying the shape of the exposure-response function
(as in \code{\link[dlnm]{crossbasis}}).}

\item{arglag}{A list specifying the shape of the lag-response function
(as in \code{\link[dlnm]{crossbasis}}).}

\item{...}{Additional arguments passed to \link[dlnm:crossbasis]{dlnm::crossbasis}, such as
\code{df}, \code{degree}, \code{knots}, etc.}
}
\value{
An object of class \code{"crossbasis_inla"} (also inheriting class \code{"crossbasis"}),
as returned by \code{dlnm:crossbasis()} but with customized column names.
}
\description{
This function is a wrapper around \link[dlnm:crossbasis]{dlnm::crossbasis}
to generate cross-basis matrices that
capture nonlinear effects of a predictor across both exposure and lag dimensions.
The input covariate is passed as a numeric matrix of lagged values, and the resulting
columns can be renamed via \code{basis_name} for easier reference in model formulas.
}
\examples{

# Build cross-basis with a custom prefix for columns

# Import example data set 
data("dengue_MS")

lag_mat <- lag_cov(data = dengue_MS,
  name = c("tmin"),
  time = "date",
  lag = c(1:6),
  group = "micro_code",
  add = FALSE) # add = FALSE return only the lagged matrix
  
cb_inla <- crossbasis_inla(
  covariate  = lag_mat,
  basis_name = "tempLag",
  lag = c(1,6),
  argvar = list(fun = "bs", df = 3),
  arglag = list(fun = "poly", degree = 2)
)

# Check class of the cross-basis object
class(cb_inla)

# View resulting cross-basis matrix
head(colnames(cb_inla))

}
