% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{compute_resolution}
\alias{compute_resolution}
\title{Compute resolution of forecasts, normalised by the uncertainty}
\usage{
compute_resolution(f, p0)
}
\arguments{
\item{f}{Vector of forecasts}

\item{p0}{Vector of base rate.
In the case rate is usually the prevalence of a uniform forecast (e.g. 1 / number of categories)
but can depend on the observation (hence the vector).}
}
\value{
Vector of resolution values
}
\description{
The resolution is computed as the mean squared distance to a base rate (reference forecast) and
is then normalised by the uncertainty (maximum resolution).
This means the output is between 0 and 1, 1 corresponding to the maximum resolution.
}
\examples{
compute_resolution(seq(0, 1, .1), 0.5)
}
