% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurrecon.R
\name{hurrecon_plot_site}
\alias{hurrecon_plot_site}
\alias{hurrecon_plot_site_all}
\alias{hurrecon_plot_tracks}
\alias{hurrecon_plot_region}
\alias{hurrecon_plot_region_dt}
\alias{hurrecon_plot_region_all}
\title{Plotting Functions}
\usage{
hurrecon_plot_site(
  hur_id,
  site_name,
  start_datetime = "",
  end_datetime = "",
  xvar = "datetime",
  yvar = "wind_speed",
  adjust = FALSE,
  legend_loc = "topright",
  title = "",
  hur_path = NULL
)

hurrecon_plot_site_all(
  site_name,
  start_year = "",
  end_year = "",
  var = "wind_speed",
  legend_loc = "topright",
  title = "",
  hur_path = NULL
)

hurrecon_plot_tracks(
  select = "all",
  wind_min = 33,
  title = "",
  colormap = "default",
  hur_path = NULL
)

hurrecon_plot_region(
  hur_id,
  var = "fujita_scale",
  subdir = "region",
  positions = FALSE,
  title = "",
  colormap = "default",
  hur_path = NULL
)

hurrecon_plot_region_dt(
  hur_id,
  dt,
  var = "fujita_scale",
  positions = FALSE,
  title = "",
  colormap = "default",
  hur_path = NULL
)

hurrecon_plot_region_all(
  var = "efmax",
  tracks = FALSE,
  title = "",
  colormap = "default",
  hur_path = NULL
)
}
\arguments{
\item{hur_id}{hurricane id}

\item{site_name}{name of site}

\item{start_datetime}{optional start datetime (YYYY-MM-DD hh:mm)}

\item{end_datetime}{optional end datetime (YYYY-MM-DD hh:mm)}

\item{xvar}{dependent variable}

\item{yvar}{independent variable}

\item{adjust}{whether to subtract 360 degrees from wind directions
greater than 180 degrees in scatter plot}

\item{legend_loc}{legend location}

\item{title}{optional title}

\item{hur_path}{path for current set of model runs}

\item{start_year}{optional start year}

\item{end_year}{optional end year}

\item{var}{variable to plot}

\item{select}{show all positions (all), only positions used as
model input (model), or none (none)}

\item{wind_min}{the minimum value of maximum sustained wind speed 
(meters/second)}

\item{colormap}{color palette}

\item{subdir}{whether to plot results from hurrecon_model_region (region)
or hurrecon_model_region_all (region-all)}

\item{positions}{whether to plot original positions}

\item{dt}{datetime in the format YYYY-MM-DDThh:mm}

\item{tracks}{whether to also plot hurricane tracks}
}
\value{
no return value

no return value

no return value

no return value

no return value

no return value
}
\description{
hurrecon_plot_site creates a time-series plot (wind speed, gust 
speed, or wind direction as a function of datetime) or a scatter 
plot (wind speed or gust speed as a function of wind direction) 
for a given hurricane and site. Optional start and end datetimes 
may be specified. X-variables: datetime or wind_direction. 
Y-variables: wind_speed, gust_speed, or wind_direction.

hurrecon_plot_site_all creates a time-series plot of peak values 
for all hurricanes for a given site. Optional start and end years
may be specified. Variables to plot: wind_speed, gust_speed, or
wind_direction.

hurrecon_plot_tracks creates a regional plot of the land-water file
and selected hurricane tracks.

hurrecon_plot_region creates regional plots of peak wind speed, peak 
enhanced Fujita scale, peak wind direction, peak cardinal wind direction,
and duration of EF0, EF1, EF2, EF3, EF4, and EF5 winds for a given hurricane.
Variables to plot: wind_speed, fujita_scale, wind_direction, wind_compass, 
ef0, ef1, ef2, ef3, ef4, and ef5.

hurrecon_plot_region_dt creates regional plots of enhanced Fujita scale, 
wind speed, wind direction, and cardinal wind direction for a given hurricane
at a specified datetime. Variables to plot: wind_speed, fujita_scale, 
wind_direction, or wind_compass.

hurrecon_plot_region_all creates regional plots of maximum enhanced Fujita
value and number of storms for each enhanced Fujita value for all hurricanes.
Variables to plot: efmax, ef0, ef1, ef2, ef3, ef4, or ef5.
}
