% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{explain}
\alias{explain}
\title{explain}
\usage{
explain(Explanation, Explanandum, matrix, weight = 1)
}
\arguments{
\item{Explanation}{Vector of Explanations that explain the Explanadum}

\item{Explanandum}{A proposition or phenomenon that is explained}

\item{matrix}{Matrix of Explanatory relations that is modified}

\item{weight}{Strength of connection (i.e., quality of explanation)}
}
\value{
Returns the explanatory matrix with the edge weights modified according
to the specified explanation
}
\description{
Sets an explanatory relation between a set of propositions and a phenomenon.
If more than one proposition is used the edge weight will be reduced accordingly.
}
\examples{
# simple example comparing two hypotheses one of them with more explanatory breadth##
T1 <- c("H1", "H2")
Phenomena <- c("E1", "E2")
Thresholds <- c(2,2)
explanations <- initializeNetwork(Phenomena, T1)
explanations <- explain("H1", "E1", explanations)
explanations <- explain("H1", "E2", explanations)
explanations <- explain("H2", "E2", explanations)
explanations <- contradict("H1", "H2", explanations)
coherence <- computeIMEC(explanations, Thresholds, Phenomena, T1)
summary(coherence)
plot(coherence)
}
