% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.cumulative_difference_plot}
\alias{Plot.cumulative_difference_plot}
\title{Plot the cumulative difference plot given a DataSetList.}
\usage{
Plot.cumulative_difference_plot(
  dsList,
  runtime_or_target_value,
  isFixedBudget,
  alpha = 0.05,
  EPSILON = 1e-80,
  nOfBootstrapSamples = 1000,
  dataAlreadyComputed = FALSE,
  precomputedData = NULL
)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension and two algorithms).}

\item{runtime_or_target_value}{The target runtime or the target value}

\item{isFixedBudget}{Should be TRUE when target runtime is used. False otherwise.}

\item{alpha}{1 minus the confidence level of the confidence band.}

\item{EPSILON}{If abs(x-y) < EPSILON, then we assume that x = y.}

\item{nOfBootstrapSamples}{The number of bootstrap samples used in the estimation.}

\item{dataAlreadyComputed}{If false, `generate_data.CDP` will be called to process the data.}

\item{precomputedData}{only needed when dataAlreadyComputed=TRUE. The result of `generate_data.CDP`.}
}
\value{
A cumulative difference plot.
}
\description{
Plot the cumulative difference plot given a DataSetList.
}
\examples{
if (rlang::is_installed("RVCompare")) {
dsl
dsl_sub <- subset(dsl, funcId == 1)
target <- 15
Plot.cumulative_difference_plot(dsl_sub, target, FALSE)
}
}
