% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_daily.R
\name{mean_daily}
\alias{mean_daily}
\title{Calculate mean daily metrics from daily summary}
\usage{
mean_daily(
  data,
  Weekend.type = Date,
  na.rm = TRUE,
  calculate.from.Date = NULL,
  prefix = "average_",
  filter.empty = FALSE,
  sub.zero = FALSE,
  Datetime2Time = TRUE
)
}
\arguments{
\item{data}{A dataframe containing the metrics to summarize}

\item{Weekend.type}{A column in the dataframe that specifies the day of the
week as a factor, where weekstart is Monday (so weekends are 6 and 7 in
numeric representation). If it is a date, it will be converted to this
factor}

\item{na.rm}{Logical, whether to remove NA values when calculating means.
Default is TRUE.}

\item{calculate.from.Date}{Optional. A column in the dataframe containing
dates from which to calculate the Weekend.type. If provided, Weekend.type
will be generated from this column.}

\item{prefix}{String that is the prefix on summarized values}

\item{filter.empty}{Filter out empty rows. Default is FALSE}

\item{sub.zero}{Logical. Should missing values be replaced by zero? Defaults
to \code{FALSE}. Will throw an error, if it happens on a type other than
\code{double}.}

\item{Datetime2Time}{Logical of whether POSIXct columns should be transformed
into hms(time) columns, which is usually sensible for averaging (default is
\code{TRUE}). Calls \code{\link[=Datetime2Time]{Datetime2Time()}} with default settings (all POSIXct are
affected).}
}
\value{
A dataframe with three rows representing average weekday, weekend,
and mean daily values of all numeric columns
}
\description{
\code{mean_daily} calculates a three-row summary of metrics showing average
weekday, weekend, and mean daily values of all non-grouping numeric columns.
The basis is a dataframe that contains metrics per weekday, or per date (with
\code{calculate.from.Date = Datetime}). The function requires a column specifying
the day of the week as a factor (with Monday as the weekstart), or it can
calculate this from a date column if provided.
}
\details{
Summary values for type \code{POSIXct} are calculated as the mean, which can be
nonsensical at times (e.g., the mean of Day1 18:00 and Day2 18:00, is Day2
6:00, which can be the desired result, but if the focus is on time, rather
then on datetime, it is recommended that values are converted to times via
\code{\link[hms:hms]{hms::as_hms()}} before applying the function (the mean of 18:00 and 18:00 is
still 18:00, not 6:00).
}
\examples{
# Create sample data
sample_data <- data.frame(
  Date = factor(c("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"),
               levels = c("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun")),
  lux = c(250, 300, 275, 280, 290, 350, 320),
  duration = lubridate::as.duration(c(120, 130, 125, 135, 140, 180, 160))
)

# Calculate mean daily metrics
mean_daily(sample_data)

# With a Date column
sample_data_with_date <- data.frame(
  Date = seq(as.Date("2023-05-01"), as.Date("2023-05-07"), by = "day"),
  lux = c(250, 300, 275, 280, 290, 350, 320),
  duration = lubridate::as.duration(c(120, 130, 125, 135, 140, 180, 160))
)

mean_daily(sample_data_with_date)

}
