% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pairwise_Schur_product}
\alias{pairwise_Schur_product}
\title{Compute Schur products (element-wise) of all pairwise combinations of columns in matrix}
\usage{
pairwise_Schur_product(x, self = FALSE)
}
\arguments{
\item{x}{A matrix with dimensions r*c.}

\item{self}{A logical that determines whether a column should also be multiplied by itself.}
}
\value{
A matrix with the same number of rows as x and a number of columns corresponding to c choose 2 (+ c if self is TRUE), where c is the number of columns of x.
}
\description{
Fast computation of all pairwise element-wise column products of a matrix.
}
\details{
Note that the output order of columns corresponds to the order of the columns in x. First column 1 is multiplied with each of the other columns, then column 2 with the remaining columns etc.
}
\examples{

X <- cbind(rep(1, 4), 1:4, 4:1)
pairwise_Schur_product(X)
pairwise_Schur_product(X, self=TRUE)

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
