% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_graph_nn}
\alias{plot_graph_nn}
\title{Plot Neural Network Architecture}
\usage{
plot_graph_nn(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
Plots a graph visualization of the Neural Network's architecture along with its optimized hyperparameters.
}
\examples{
# Note: For obtaining the Neural Network architecture graph plot the user needs to
# complete till the fine_tuning( ) function of the MLwrap pipeline.

if (requireNamespace("torch", quietly = TRUE)) {

  \dontrun{

  wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
  wrap_object <- build_model(wrap_object, "Neural Network")
  wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

  # And then, you can obtain the Neural Network architecture graph plot.

  plot_graph_nn(wrap_object)

  }

}

}
