% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_olden_results}
\alias{table_olden_results}
\title{Olden Results Table}
\usage{
table_olden_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "Olden")'.}

\item{show_table}{Boolean. Whether to print the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with Olden
results.
}
\description{
The \strong{table_olden_results()} function extracts results from the Olden
method, a technique specific to neural networks that calculates relative
importance of input variables through analysis of connection weights between
network layers. This method provides a measure of each variable's
contribution based on the magnitude and direction of synaptic connections.
}
\examples{
# Note: For obtaining the table with Olden method results the user needs to
# complete till sensitivity_analysis() function of the MLwrap pipeline using
# the Olden method. Remember Olden method only can be used with neural
# network model.
# See the full pipeline example under sensitivity_analysis
# (Requires sensitivity_analysis(methods = "Olden"))
# Final call signature:
# table_olden_results(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
