% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_nondominated_points.R
\name{find_nondominated_points}
\alias{find_nondominated_points}
\title{Find non-dominated points}
\usage{
find_nondominated_points(Y)
}
\arguments{
\item{Y}{row matrix of points in the space of objectives.}
}
\value{
logical vector of length \code{nrow(Y)} indicating the nondominated points
as \code{TRUE}.
}
\description{
Non-dominated point finding for \strong{minimization} problems
}
\details{
Non-dominated point finding, based on portions of function \emph{fastNonDominatedSorting}
from package NSGA2R
(\url{https://CRAN.R-project.org/package=nsga2R})
}
\examples{
Y  <- matrix(runif(200), ncol = 2)
nd <- find_nondominated_points(Y)
plot(Y[, 1], Y[, 2], type = "p", pch = 20, las = 1)
points(Y[nd, 1], Y[nd, 2], type = "p", pch = 16, col = 2, cex = 1.5)

}
