% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variation_diffmut.R
\name{variation_diffmut}
\alias{variation_diffmut}
\title{Differential Mutation}
\usage{
variation_diffmut(X, P, B, Phi = NULL, basis = "rand", ...)
}
\arguments{
\item{X}{Population matrix}

\item{P}{Matrix of selection probabilities (generated by
\code{\link[=define_neighborhood]{define_neighborhood()}})}

\item{B}{Matrix of neighborhoods (generated by \code{\link[=define_neighborhood]{define_neighborhood()}})}

\item{Phi}{Mutation parameter. Either a scalar numeric constant, or NULL for
randomly chosen between \code{0} and \code{1} (independently sampled for
each operation).}

\item{basis}{how to select the basis vector. Currently supported methods are:
\itemize{
\item \code{basis = "rand"}, for using a randomly sampled vector from the
population;
\item \code{basis = "mean"}, for using the mean point of the
neighborhood;
\item \code{basis = "wgi"}, for using the the weighted mean point of the
neighborhood.
}}

\item{...}{other parameters to be passed down to specific options of basis
vector generation (e.g., \code{Y}, \code{Yt}, \code{W}, \code{scaling} and \code{aggfun}, required
when \code{basis = "wgi"}).}
}
\value{
Matrix \code{X}' containing the mutated population
}
\description{
Differential Mutation implementation for the MOEA/D
}
\details{
This function generalizes many variations of the Differential Mutation
operator with general form:

\code{u = x_basis + Phi(x_a - x_b)}

Where u is the new candidate vector, \code{Phi != 0} is a real number,
and \code{x_basis}, \code{x_a} and \code{x_b} are distinct vectors.

This routine is intended to be used internally by \code{\link[=perform_variation]{perform_variation()}},
and should not be called directly by the user.
}
\section{References}{

K. Price, R.M. Storn, J.A. Lampinen, "Differential Evolution: A
Practical Approach to Global Optimization", Springer 2005\cr

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr

D. V. Arnold, “Weighted multirecombination evolution strategies,”
Theoretical Computer Science 361(1):18–37, 2006.
}

