% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mram.R
\name{mram}
\alias{mram}
\title{Estimate the Multivariate Regression Association Measure}
\usage{
mram(
  y_data,
  x_data,
  z_data = NULL,
  bootstrap = FALSE,
  B = 1000,
  g_vec = seq(0.4, 0.9, by = 0.05)
)
}
\arguments{
\item{y_data}{A \eqn{n \times d} matrix of responses, where \eqn{n} is the sample size.}

\item{x_data}{A \eqn{n \times p} matrix of predictors.}

\item{z_data}{A \eqn{n \times q} matrix of conditional predictors. The default value is \code{NULL}.}

\item{bootstrap}{Perform the \eqn{m}-out-of-\eqn{n} bootstrap if \code{TRUE}. The default value is \code{FALSE}.}

\item{B}{Number of bootstrap replications. The default value is \code{1000}.}

\item{g_vec}{A vector of candidate values for \eqn{\gamma} between 0 and 1, used to generate a collection of rules for the \eqn{m}-out-of-\eqn{n} bootstrap. The default value is \code{seq(0.4,0.9,by = 0.05)}.}
}
\value{
\item{T_est}{The estimate of the multivariate regression association measure. The value returned by \code{T_est} is between \eqn{-1} and \eqn{1}. However, it is between \eqn{0} and \eqn{1} asymptotically. A small value indicates that \code{x_data} has low predictability for \code{y_data} condition on \code{z_data} in the sense of the considered measure. On the other hand, a large value indicates that \code{x_data} has high predictability for \code{y_data} condition on \code{z_data}. If \code{z_data = NULL}, the returned value indicates the unconditional predictability.}
\item{T_se_cluster}{The standard error estimate based on the cluster rule.}
\item{m_vec}{The vector of \eqn{m} generated by \code{g_vec}.}
\item{T_se_vec}{The vector of standard error estimates obtained from the \eqn{m}-out-of-\eqn{n} bootstrap, where \eqn{m} is equal to \code{m_vec}.}
\item{J_cluster}{The index of the best \code{m_vec} chosen by the cluster rule.}
}
\description{
Compute \eqn{T_n} and its standard error estimates using the nearest neighbor method and the \eqn{m}-out-of-\eqn{n} bootstrap.
}
\details{
Let \eqn{\{({\bf X}_i,{\bf Y}_i,{\bf Z}_i)\}_{i = 1}^n} be independent and identically distributed data from the population \eqn{({\bf X},{\bf Y},{\bf Z})}. The estimate \eqn{T_n({\bf X},{\bf Y})} for the unconditional measure (\code{z_data = NULL}) is given as

\deqn{T_n({\bf X},{\bf Y}) = \binom{n}{2}^{-1} \sum_{i < j} \langle S({{\bf Y}_i - {\bf Y}_j}), S({{\bf Y}_{N(i)} - {\bf Y}_{N(j)}}) \rangle,}

where \eqn{\langle \cdot, \cdot \rangle} is the dot product, \eqn{S(\cdot)} is the spatial sign function, and \eqn{N(i)} is the index \eqn{j} such that \eqn{{\bf X}_j} is the nearest neighbor of \eqn{{\bf X}_i} according to the Euclidean distance. The estimate \eqn{T_n({\bf X},{\bf Y} \mid {\bf Z})} for the conditional measure is given as

\deqn{T_n({\bf X},{\bf Y} \mid {\bf Z} ) = \frac{T_n(({\bf X},{\bf Z}),{\bf Y} ) - T_n({\bf Z},{\bf Y} )}{1 - T_n({\bf Z},{\bf Y} )}.}

See the paper Shih and Chen (2025, in revision) for more details.

For the \eqn{m}-out-of-\eqn{n} bootstrap, the rule (resample size) is set to be \eqn{m = \lfloor n^\gamma \rfloor}, where \eqn{\lfloor x \rfloor} denotes the largest integer that is smaller than or equal to \eqn{x} and \eqn{0 < \gamma < 1} takes values from the vector \code{g_vec}. It is recommended to use \code{T_se_cluster}, the standard error estimate obtained based on the cluster rule. See Dette and Kroll (2024) for more details.

The \code{mram} function is used in \code{\link{vs_mram}} function for variable selection.
}
\examples{
library(MRAM)

n = 100

set.seed(1)
x_data = matrix(rnorm(n*2),n,2)
y_data = matrix(0,n,2)
y_data[,1] = x_data[,1]*x_data[,2]+x_data[,1]+rnorm(n)
y_data[,2] = x_data[,1]*x_data[,2]-x_data[,1]+rnorm(n)

mram(y_data,x_data[,1],x_data[,2])
mram(y_data,x_data[,2],x_data[,1])
mram(y_data,x_data[,1])
mram(y_data,x_data[,2])

\dontrun{

# perform the m-out-of-n bootstrap
mram(y_data,x_data[,1],x_data[,2],bootstrap = TRUE)
mram(y_data,x_data[,2],x_data[,1],bootstrap = TRUE)
mram(y_data,x_data[,1],bootstrap = TRUE)
mram(y_data,x_data[,2],bootstrap = TRUE)
}
}
\references{
Dette and Kroll (2024) A Simple Bootstrap for Chatterjee’s Rank Correlation, Biometrika, asae045.

Shih and Chen (2025) Measuring multivariate regression association via spatial sign (in revision, Computational Statistics & Data Analysis)
}
\seealso{
\code{\link{vs_mram}}
}
