% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRGcluster.R
\name{MRGcluster}
\alias{MRGcluster}
\title{Function that allows to apply parallel processing}
\usage{
MRGcluster(nclus, ..., action = "start", clusType, outfile = NULL)
}
\arguments{
\item{nclus}{Number of clusters to use for parallel processing. No parallelization is used
for \code{nclus = 1}.}

\item{...}{arguments that should be evaluated in the cluster (can also be called later)}

\item{action}{Defines the action of the function. There are three options:
\describe{
  \item{"start"}{Starts a new cluster if necessary, reuses an existing if it has already been started}
  \item{"restart"}{Stops the cluster and starts it again. To be used in case there are difficulties with the cluster,
          or if the user wants to change the type of the cluster}
}}

\item{clusType}{The type of cluster; see \code{\link[parallel]{makeCluster}} for more details.
The default of makeCluster is used if type is missing or NA.}

\item{outfile}{File to direct the output, \code{\link[parallel]{makeCluster}} for more details.}
}
\value{
The function will either return a cluster for parallel computation,
or stop a cluster (returning NULL)
}
\description{
Function that allows to apply parallel processing
}
