\name{MSeasyToMSP}

\alias{MSeasyToMSP}

\title{Convert output files from MS.clust into MSP format for NIST mass spectral library search}

\description{
MSeasyToMSP export mass spectra from the output files generated by MS.clust into a MSP file compatible with NIST mass spectral library search tool. It is possible to consider only mass spectra from a selected subset of clusters. tcltk package is needed.}

\usage{MSeasyToMSP(filename="", outfilename="", cluster="", autosearch=FALSE)}

\arguments{
  \item{filename}{text file as returned by \emph{MS.clust} (\code{Output_peak.txt} or \code{Output_cluster.txt}.
  If left empty, a popup window opens to specify the location of the input file)}

  \item{outfilename}{ Name for the MSP output file (if left empty default is ForNIST}

  \item{cluster}{If \code{cluster = numeric()}, to select one or a subset of clusters for identification.}

  \item{autosearch}{ONLY on WINDOWS plateforms when NIST mssearch is installed! If \code{autosearch = TRUE}, then the MSP file created is automatically sent to your NIST MS search tool.
	See also the function \code{SearchNIST} of \code{MSeasy}}
  }
\value{ A file compatible with the NIST mass spectral library search tool (*.MSP file) is created in a new folder \emph{output_MStoMSP_result_time}
	}
	
\author{Yann Guitton}

\seealso{
tcltk, SearchNIST
}

\examples{
#Not run
#Not run
\dontrun{ 
pathexample<-system.file("doc/Output_examples",
package="MSeasy")
MSeasyToMSP(file.path(pathexample,"Output_peak21.txt"), cluster=5)

MSeasyToMSP(file.path(pathexample,"Output_cluster21.txt"))
}




}

