% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing.R
\name{impute_missing}
\alias{impute_missing}
\title{Impute Missing Values}
\usage{
impute_missing(
  data,
  method = c("mean", "median", "mice"),
  m = 5,
  seed = 123,
  ...
)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{method}{Character; one of \code{"mean"}, \code{"median"}, or \code{"mice"}. Default: \code{"mean"}.}

\item{m}{Integer; number of multiple imputations when \code{method = "mice"}. Default: 5.}

\item{seed}{Integer; random seed for \code{mice} imputation. Default: 123.}

\item{...}{Additional arguments passed to \code{mice::mice} when \code{method = "mice"}.}
}
\value{
A data frame with missing values imputed.
}
\description{
Replace \code{NA}s in numeric variables using simple methods or \code{mice}-based imputation.
}
\examples{
\dontrun{
df <- data.frame(x = c(1, NA, 3), y = c(4, 5, NA))
impute_missing(df, method = "mice")
}
}
