% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USCensusCounties_02}
\alias{USCensusCounties_02}
\title{US Census Counties SpatialPolygonsDataFrame}
\format{
A SpatialPolygonsDataFrame (SPDF) with 3169 observations and 9 variables.
}
\usage{
USCensusCounties_02
}
\description{
The \code{USCensusCounties_02} dataset provides a SPDF of US counties to
use in code examples. It is created from converting a US county borders
shapefile to a SpatialPolygonsDataFrame with additional columns of data. The
code for creating it demonstrates creation of a SPDF that is
compatible with \code{countyMap()}. See the \pkg{MazamaSpatialUtils} package for the
function \code{convertUSCensusCounties()} that creates this SPDF.

This dataset was generated on 2020-07-29 by running:

\preformatted{
library(MazamaSpatialUtils)

setSpatialDataDir("~/Data/Spatial")

MazamaSpatialUtils::convertUSCensusCounties()

MazamaSpatialUtils::loadSpatialData("USCensusCounties_02")

save(USCensusCounties_02, file = "data/USCensusCounties_02.rda")
}
}
\keyword{datasets}
