% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.phylogenetic.tree.R
\name{get.phylogenetic.tree}
\alias{get.phylogenetic.tree}
\title{Phylogenetic Tree}
\usage{
get.phylogenetic.tree(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  method = NULL,
  individual.names = NULL,
  circular = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{path}{provide a path if the dendrogram would be saved as a png-file}

\item{database}{Groups of individuals to consider}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{method}{Method used to calculate genetic distances (default: "Nei", alt: "Rogers", "Prevosti", "Modified Rogers"}

\item{individual.names}{Names of the individuals in the database ((default are MoBPS internal names based on position))}

\item{circular}{Set to TRUE to generate a fan/circular layout tree}
}
\value{
Dendrogram plot for traits
}
\description{
Function calculate a phylogenetic tree
}
\examples{
data(ex_pop)
get.phylogenetic.tree(ex_pop, gen=1, circular=TRUE)
}
