% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_wsd.R
\name{nd.wsd}
\alias{nd.wsd}
\title{Distance with Weighted Spectral Distribution}
\usage{
nd.wsd(A, out.dist = TRUE, K = 50, wN = 4)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{K}{the number of bins for the spectrum interval \eqn{[0,2].}}

\item{wN}{a decaying exponent; default is \eqn{4} set by authors.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M)} matrix of rows being eigenvalues for each graph.}
}
}
\description{
Normalized Laplacian matrix contains topological information of
a corresponding network via its spectrum. \code{nd.wsd} adopts weighted
spectral distribution of eigenvalues and brings about a metric via
binning strategy.
}
\examples{
## load example data and extract a few
data(graph20)
gr.small = graph20[c(1:5,11:15)]

## compute distance matrix
output = nd.wsd(gr.small, out.dist=FALSE, K=10)

## visualize
opar = par(no.readonly=TRUE)
par(pty="s")
image(output$D[,10:1], main="two group case", axes=FALSE, col=gray(0:32/32))
par(opar)

}
\references{
\insertRef{fay_weighted_2010}{NetworkDistance}
}
