% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourTwo.r
\name{fourTwo.start}
\alias{fourTwo.start}
\alias{fourTwo.step}
\alias{fourTwo.stop}
\alias{fourTwo.final}
\title{4-2 Staircase}
\usage{
fourTwo.start(est = 25, instRange = c(0, 40), verbose = FALSE, makeStim, ...)

fourTwo.step(state, nextStim = NULL)

fourTwo.stop(state)

fourTwo.final(state)
}
\arguments{
\item{est}{Starting estimate in dB}

\item{instRange}{Dynamic range of the instrument c(min,max) in dB}

\item{verbose}{True if you want each presentation printed}

\item{makeStim}{A function that takes a dB value and numPresentations
and returns an OPI datatype ready for passing to opiPresent}

\item{...}{Extra parameters to pass to the opiPresent function}

\item{state}{Current state of the fourTwo returned by
\code{fourTwo.start} and \code{fourTwo.step}}

\item{nextStim}{A valid object for \code{opiPresent} to
use as its \code{nextStim}.}
}
\value{
\subsection{Multilple locations}{
\code{fourTwo.start} returns a list that can be passed to \code{fourTwo.step},
\code{fourTwo.stop}, and \code{fourTwo.final}. It represents the state of a fourTwo
at a single location at a point in time and contains the following.
\itemize{
\item{name:}{\code{ fourTwo}}
\item{}{ A copy of all of the parameters supplied to fourTwo.start:
\code{startingEstimate=est}, \code{minStimulus=instRange[1]},
\code{maxStimulus=instRange[2]}, \code{makeStim}, and \code{opiParams=list(...)}}
\item{currentLevel:}{ The next stimulus to present.}
\item{lastSeen:}{ The last seen stimulus.}
\item{lastResponse:}{ The last response given.}
\item{stairResult:}{ The final result if finished (initially \code{NA}).}
\item{finished:}{ \code{"Not"} if staircae has not finished, or one of
\code{"Rev"} (finished due to 2 reversas), \code{"Max"} (finished due to 2
\code{maxStimulus} seen), \code{"Min"} (finished due to 2 \code{minStimulus} not seen)}
\item{numberOfReversals:}{ Number of reversals so far.}
\item{currSeenLimit:}{ Number of times \code{maxStimulus} has been seen.}
\item{currNotSeenLimit:}{ Number of times \code{minStimulus} not seen.}
\item{numPresentations:}{ Number of presentations so far.}
\item{stimuli:}{ Vector of stimuli shown at each call to \code{fourTwo.step}.}
\item{responses:}{ Vector of responses received (1 seen, 0 not) receieved at each call to \code{fourTwo.step}.}
\item{responseTimes:}{ Vector of response times receieved at each call to \code{fourTwo.step}.}
}
\code{fourTwo.step} returns a list containing
\itemize{
\item{state:}{ The new state after presenting a stimuli and getting a response.}
\item{resp:}{ The return from the \code{opiPresent} call that was made.}
}
\code{fourTwo.stop} returns \code{TRUE} if the staircase is finished (2 reversals, or \code{maxStimulus}
is seen twice or \code{minStimulus} is not seen twice).

\code{fourTwo.final} returns the final estimate of threshold (mena of last
two reversals). This issues a warning if called before the staircase has
finished, but still returns a value.
}
}
\description{
fourTwo is a 4-2 dB staircase beginning at level \code{est}
terminating after two reversals. The final estimate is the average of the
last two presentations. It also terminates if the \code{minStimulus} is
not seen twice, or the \code{maxStimulus} is seen twice.
}
\details{
This is an implementation of a 4-2 1-up 1-down staircase. The
initial staircase starts at \code{est} and proceeds in steps of 4 dB until
the first reversal, and 2dB until the next reversal. The mean of the last
two presentations is taken as the threshold value. Note this function will
repeatedly call \code{opiPresent} for a stimulus until \code{opiPresent}
returns \code{NULL} (ie no error occured). If more than one fourTwo is to
be interleaved (for example, testing multiple locations), then the
\code{fourTwo.start}, \code{fourTwo.step}, \code{fourTwo.stop} and
\code{fourTwo.final} calls can maintain the state of the fourTwo after
each presentation, and should be used. See examples below.
}
\examples{
# Stimulus is Size III white-on-white as in the HFA
makeStim <- function(db, n) {
  s <- list(x=9, y=9, level=dbTocd(db), size=0.43, color="white",
            duration=200, responseWindow=1500)
  class(s) <- "opiStaticStimulus"
  return(s)
}
chooseOpi("SimHenson")
if (!is.null(opiInitialize(type="C", cap=6)))
  stop("opiInitialize failed")

##############################################
# This section is for multiple fourTwos
##############################################
makeStimHelper <- function(db,n, x, y) {  # returns a function of (db,n)
  ff <- function(db, n) db+n
  body(ff) <- substitute({
    s <- list(x=x, y=y, level=dbTocd(db), size=0.43, color="white",
              duration=200, responseWindow=1500)
    class(s) <- "opiStaticStimulus"
    return(s)}, list(x=x,y=y))
  return(ff)
}
# List of (x, y, true threshold) triples
locations <- list(c(9,9,30), c(-9,-9,32), c(9,-9,31), c(-9,9,33))

# Setup starting states for each location
states <- lapply(locations, function(loc) {
  fourTwo.start(makeStim=makeStimHelper(db,n,loc[1],loc[2]),
                tt=loc[3], fpr=0.03, fnr=0.01)})

# Loop through until all states are "stop"
while(!all(st <- unlist(lapply(states, fourTwo.stop)))) {
  i <- which(!st)                         # choose a random, 
  i <- i[runif(1, min=1, max=length(i))]  # unstopped state
  r <- fourTwo.step(states[[i]])               # step it
  states[[i]] <- r$state                  # update the states
}

finals <- lapply(states, fourTwo.final)    # get final estimates of threshold
for(i in 1:length(locations)) {
  cat(sprintf("Location (\%+2d,\%+2d) ",locations[[i]][1], locations[[i]][2]))
      cat(sprintf("has threshold \%4.2f\n", finals[[i]]))
}

if (!is.null(opiClose()))
  warning("opiClose() failed")
}
\seealso{
\code{\link{dbTocd}}, \code{\link{opiPresent}}, \code{\link{FT}}
}
