% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{opiPresent_for_Octopus900}
\alias{opiPresent_for_Octopus900}
\title{Implementation of opiPresent for the Octopus090 machine.}
\arguments{
\item{stim}{Stimulus to present (a list, see \code{octo900.present*} for details).}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}

\item{F310}{If \code{F310} is \code{FALSE}, response is taken from O900 button.
If \code{F310} is \code{TRUE}, response is taken from external controller for (static stimuli only).}
}
\description{
This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with the same arguments and
the class of \code{stim} as one of \code{opiStaticStimulus}, \code{opiTemporalStimulus}, or \code{opiKineticStimulus}.
}
\examples{
\dontrun{
  chooseOpi("Octopus900")
  if (!is.null(opiInitialize()$err))
      stop("opiInitialize failed")
  s <- list(x=9, y=9, level=dbTocd(db), size=0.43, color="white",
            duration=200, responseWindow=1500, checkFixationOK=NULL)
  class(s) <- "opiStaticStimulus"
  print(opiPresent(s, NULL))
}

}
\seealso{
\link{octo900.presentStatic}, \link{octo900.presentTemporal}, \link{octo900.presentKinetic}
}
