% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ostats_multivariate_plot.R
\name{Ostats_multivariate_plot}
\alias{Ostats_multivariate_plot}
\title{Plot multivariate community overlap}
\usage{
Ostats_multivariate_plot(
  plots,
  sp,
  traits,
  overlap_dat = NULL,
  use_plots = NULL,
  colorvalues = NULL,
  plot_points = TRUE,
  contour_level,
  axis_expansion = 0.01,
  contour_buffer_factor = 0.25,
  panel_height = 3,
  panel_width = 3,
  units = "cm",
  hypervolume_args = list()
)
}
\arguments{
\item{plots}{Site identity: a vector of names of each community.}

\item{sp}{Taxon identity: a vector of species or taxa names.}

\item{traits}{A matrix or data frame with rows representing individuals
and columns representing traits.}

\item{overlap_dat}{Optional: an object containing the output of
\code{\link{Ostats_multivariate}}.
If provided, overlap statistics will be displayed in the plot panels.}

\item{use_plots}{a vector of sites to plot. If NULL, the function will plot all the sites.}

\item{colorvalues}{Vector of color values for the density polygons.
Defaults to a viridis palette if none provided.}

\item{plot_points}{whether to plot individual data points in addition to
the hypervolume slices. Default is TRUE.}

\item{contour_level}{level at which to plot contour lines. If not provided
by the user, a message is issued stating the default plotting level is 0.01.}

\item{axis_expansion}{multiplicative expansion factor by which to expand the x and y axes around
the hypervolume contours before plotting. Default is 0.01.}

\item{contour_buffer_factor}{multiplicative expansion factor by which to expand the x and y axes in all directions,
relative to the range of the axis, before calculating the hypervolume contours for plotting.
If this is not set to a sufficiently large value, the contour lines of the hypervolumes will be cut off.
Default value is 0.25 (25\% expansion of the axis limits in all directions).}

\item{panel_height}{height of the individual plot panels, in units given by \code{units}. Default is 3 cm.}

\item{panel_width}{height of the individual plot panels, in units given by \code{units}. Default is 3 cm.}

\item{units}{units for panel height and width. Default is centimeters.}

\item{hypervolume_args}{additional arguments to pass to \code{\link[hypervolume]{hypervolume}},
such as \code{method}. If none are provided, default values are used.}
}
\value{
Two-dimensional projections of species trait hypervolumes for each pair of traits,
 plotted together for each community to show how they overlap each other.
 The overlap value obtained as output from \code{\link{Ostats_multivariate}}
 is labelled on each community graph, if provided by the user.

 The class of the returned object is \code{Ostats_plot_object}. Calling
 \code{print} on this object will invoke a method to draw the plot using
 \code{\link[grid]{grid.draw}}.

 If more than one community is provided, a list of objects of class
 \code{Ostats_plot_object} will be returned.
}
\description{
This function plots the overlap of traits among
 species for each community in multivariate space, showing
 projections of trait hypervolumes into two-dimensional space for
 all pairs of traits.
}
\details{
Some of the code for generating contour lines is modified from
  \code{\link[hypervolume:plot.Hypervolume]{plot.HypervolumeList}}.
}
\seealso{
\code{\link{Ostats_multivariate}} for generating multivariate O-statistics
}
