% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIfun.R
\name{ti.ctplot}
\alias{ti.ctplot}
\title{Heatmap/Contour Plot for Assessing Power of the PPQ Plan using Tolerance Interval.}
\usage{
ti.ctplot(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch,
alpha, coverprob, side, test.point)
}
\arguments{
\item{attr.name}{user-defined attribute name for PPQ assessment}

\item{attr.unit}{user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{alpha}{significant level for constructing the tolerance interval.}

\item{coverprob}{converage probability for constructing the tolerance interval}

\item{side}{whether a 1-sided or 2-sided tolerance interval is required (determined by side = 1 or side = 2, respectively).}

\item{test.point}{(optional) actual process data points for testing whether the processes pass PPQ}
}
\value{
Heatmap (or Countour Plot) for PPQ Assessment.
}
\description{
The function for plotting the heatmap to evaluate the PPQ plan based on the specification test, given lower and upper specification limits.
}
\examples{

mu <- seq(95,105,0.1)
sigma <- seq(0.1,2.5,0.1)
ti.ctplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%",
mu = mu, sigma = sigma, Llim=95, Ulim=105)

ti.ctplot(attr.name = "Extractable Volume", attr.unit = "\% of NV=1mL",
Llim = 100, Ulim = Inf, mu=seq(100, 110, 0.5), sigma=seq(0.2, 15 ,0.5), n=40,
alpha = 0.05, coverprob = 0.675, side=1)

}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{ti.pp} and \code{ti.occurve}.
}
\author{
Yalin Zhu
}
