% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugmm.R
\name{pugmm}
\alias{pugmm}
\title{Parsimonious Ultrametric Gaussian Mixture Models}
\usage{
pugmm(
  X,
  G = NULL,
  m = NULL,
  normalization = NULL,
  model = NULL,
  maxiter = 500,
  tol = 1e-06,
  stop = "aitken",
  rndstart = 1,
  initG = "kmeans",
  initm = "ucms",
  gaussian = "mclust",
  parallel = FALSE
)
}
\arguments{
\item{X}{(\eqn{n \times p}) numeric matrix or data frame, where \eqn{n} and \eqn{p} represent the number of units and variables, respectively. Categorical variables are not allowed.}

\item{G}{Integer (vector) specifying the number of mixture components (default: \code{G = 1:5}).}

\item{m}{Integer (vector) specifying the number of variable groups (default: \code{m = 1:5}).}

\item{normalization}{Character string specifying the data transformation. If \code{NULL}, no transformation is applied to the data matrix (default). Other options are: "standard" for the standardization; "center" for centering the data; "range" for the MinMax transformation; "SVD" for the Singular Value Decomposition transformation.}

\item{model}{Vector of character strings indicating the model names to be fitted. If \code{NULL}, all the possible models are fitted (default). See the possible models using \code{available_models()}.}

\item{maxiter}{Integer value specifying the maximum number of iterations of the algorithm (default: \code{maxiter = 500}).}

\item{tol}{Numeric value specifying the tolerance for the convergence criterion (default: \code{tol = 1e-6}).}

\item{stop}{Character string specifying the convergence criteria. If "aitken", the Aitken acceleration-based stopping rule is used (default); if "relative", the relative log-likelihood in two sequential iterations is evaluated.}

\item{rndstart}{Integer value specifying the number of random starts (default: \code{rndstart = 1}).}

\item{initG}{Character string specifying the method for the initialization of the unit-component membership. If "kmeans", k-means via RcppArmadillo is used (default). Other options are: "random" for random assignment; "kmeansf" for fuzzy c-means (via the function fcm of the package ppclust).}

\item{initm}{Character string specifying the method for the initialization of the variable-group membership. If "ucms", the multivariate model to be used for obtaining the variable-group membership estimated is the same model.name used for estimating the Parsimonious Ultrametric Gaussian Mixture Model (default); if "random", a random assignment is performed.}

\item{gaussian}{Character string specifying the way to compute the log-likelihood. If "mclust", \code{dmvnorm} of \code{mclust} is used (default); if "canonical", the log-likelihood computation is based upon the canonical representation of an extended ultrametric covariance matrix.}

\item{parallel}{A logical value, specifying whether the models should be run in parallel.}
}
\value{
An object of class \code{pugmm} containing the results of the optimal - according to BIC - Parsimonious Ultrametric Gaussian Mixture Model estimation. \cr

\code{call} Matched call.

\code{X} Input data matrix.

\code{G} Number of components of the best model.

\code{m} Number of variable groups of the best model.

\code{label} Integer vector of dimension \eqn{n}, taking values in \eqn{\{1, \ldots, G\}}. It identifies the unit classification according to the maximum a posteriori of the best model.

\code{pp} Numeric vector of dimension \eqn{G} containing the prior probabilities for the best model.

\code{mu} (\eqn{G \times p}) numeric matrix containing the component mean vectors (by row) for the best model.

\code{sigma} List of dimension \eqn{G} containing the (\eqn{p \times p}) numeric component extended ultrametric covariance matrices for the best model.

\code{V} List of dimension \eqn{G} containing the (\eqn{p \times m}) binary variable-group membership matrices for the best model.

\code{Sv} List of dimension \eqn{G} containing the (\eqn{m \times m}) numeric diagonal matrices of the group variances for the best model.

\code{Sw} List of dimension \eqn{G} containing the (\eqn{m \times m}) numeric diagonal matrices of the within-group covariances for the best model.

\code{Sb} List of dimension \eqn{G} containing the (\eqn{m \times m}) numeric hallow matrices of the between-group covariances for the best model.

\code{post} (\eqn{n \times G}) numeric matrix containing the posterior probabilities for the best model.

\code{pm} Number of parameters of the best model.

\code{pm.cov} Number of covariance parameters of the best model.

\code{pm.free} Number of free parameters of the best model (\code{pm} - (constraints on \eqn{V} + \code{count.constr.SwSb} + \code{count.constr.SvSw})).

\code{count.constr.SwSb} Number of times the constraint between \code{Sw} and \code{Sb} has been turned on for the best model.

\code{count.constr.SvSw} Number of times the constraint between \code{Sv} and \code{Sw} has been turned on for the best model.

\code{BIC} BIC values for all the fitted models. If BIC is \eqn{NA}, the model has not been computed since its structure is equal to another model, while if BIC is \eqn{-Inf} the solution has a number of clusters \eqn{< G}.

\code{bic} BIC value of the best model.

\code{loglik} Log-likelihood of the best model.

\code{loop} Random start corresponding to the selected solution of the best model.

\code{iter} Number of iterations needed to estimate the best model.

\code{model.name} Character string denoting the PUGMM model name of the best model among the ones fitted.

\code{messages} Messages.
}
\description{
Model-based clustering via Parsimonious Ultrametric Gaussian Mixture Models. Hierarchical relationships among variables within and between clusters are inspected. The grouped coordinate ascent algorithm is used for the parameter estimation. The optimal model is selected according to BIC.
}
\details{
The grouped coordinate ascent algorithm used for the estimation of PUGMMs parameters was demonstrated to be equivalent to an Expectation-Maximization algorithm in the GMM framework (Hathaway, 1986).
}
\examples{
data(penguins)
x <- scale(penguins[, 2:5])
pugmm.penguins <- pugmm(x, 3, 1)
table(penguins$species, pugmm.penguins$label)
\donttest{
pugmm.penguins <- pugmm(x)
pugmm.penguins$G
pugmm.penguins$m
pugmm.penguins$model.name}
}
\references{
Cavicchia, C., Vichi, M., Zaccaria, G. (2024) Parsimonious ultrametric Gaussian mixture models. \emph{Statistics and Computing}, 34, 108.

Cavicchia, C., Vichi, M., Zaccaria, G. (2022) Gaussian mixture model with an extended ultrametric covariance structure. \emph{Advances in Data Analysis and Classification}, 16(2), 399-427.

Hathaway, R. (1986) Another interpretation of the EM algorithm for mixture distributions. \emph{Statistics and Probability Letters}, 4(2), 53-56.
}
\seealso{
\code{\link[=pugmm_available_models]{pugmm_available_models()}}, \code{\link[=plot.pugmm]{plot.pugmm()}}
}
