% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{combine_scores}
\alias{combine_scores}
\title{Combine multiple score panels (mean / weighted / rank-average / trimmed)}
\usage{
combine_scores(
  scores_list,
  method = c("mean", "weighted", "rank_avg", "trimmed_mean"),
  weights = NULL,
  trim = 0.1
)
}
\arguments{
\item{scores_list}{List of wide score panels to combine (each has columns \code{Date} + symbols).}

\item{method}{Character, one of \code{"mean"}, \code{"weighted"}, \code{"rank_avg"}, \code{"trimmed_mean"}.}

\item{weights}{Optional numeric vector of length equal to \code{length(scores_list)}; used only when \code{method = "weighted"}.}

\item{trim}{Numeric in \code{[0, 0.5)}; fraction to trim from each tail for \code{method = "trimmed_mean"}.}
}
\value{
A \code{data.table} with columns \code{Date} + symbols, containing the combined scores.
}
\description{
Combine several wide score panels (\code{Date} + symbols) into a single panel
by applying one of several aggregation methods.
}
\details{
\itemize{
\item \code{method = "mean"}: simple column-wise mean across panels.
\item \code{method = "weighted"}: weighted mean; see \code{weights}.
\item \code{method = "rank_avg"}: average of within-date normalized ranks.
\item \code{method = "trimmed_mean"}: mean with \code{trim} fraction removed at both tails.
}
}
