% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-WLS.R
\name{method.WLS}
\alias{method.WLS}
\title{WLS (Weighted Least Squares) Method}
\usage{
\method{method}{WLS}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (no settings version are implemented)}
}
\value{
Data frame with WLS results
}
\description{
Implements the Weighted Least Squares method for meta-analysis.
WLS fits a weighted regression model with effect sizes as the outcome
and weights based on the inverse of the squared standard errors.
The intercept represents the weighted average effect size estimate.
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply WLS method
result <- run_method("WLS", data)
print(result)

}
\references{
\insertAllCited{}
}
