% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2ct.R
\name{test2ct}
\alias{test2ct}
\title{Test2.CT}
\usage{
test2ct(X, freq, verbose = TRUE, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories with K occasions}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{verbose}{controls the level of the details in the outputs; default is TRUE for all details}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a list with first component the overall test and second component a data.frame with 5 columns for components i (2:K-2) (in rows) of test2.Cti: component, degree of freedom, statistic of the test, p-value, signed test, test performed.
}
\description{
This function performs Test2.CT
}
\examples{
# read in the classical dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
dipper = read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))

# Get encounter histories, counts and groups:
dip.hist = dipper$encounter_histories
dip.freq = dipper$sample_size
dip.group = dipper$groups

# split the dataset in males/females
mask = (dip.group == 'Female')
dip.fem.hist = dip.hist[mask,]
dip.fem.freq = dip.freq[mask]
mask = (dip.group == 'Male')
dip.mal.hist = dip.hist[mask,]
dip.mal.freq = dip.freq[mask]

# for females
X = dip.fem.hist
freq = dip.fem.freq
res.females = test2ct(X,freq)
res.females
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}
