% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_mixOmics.R
\docType{methods}
\name{import_mixOmics}
\alias{import_mixOmics}
\alias{import_mixOmics,GCxGC-method}
\alias{import_mixOmics,PLSDA-method}
\title{Import mixOmics discriminant analysis}
\usage{
import_mixOmics(chromatogram, model, mod_time, time_range, sampling_rt)

\S4method{import_mixOmics}{GCxGC}(chromatogram, model, mod_time, time_range, sampling_rt)
}
\arguments{
\item{chromatogram}{a typicial GCxGC imported or preprocessed chromatogram.}

\item{model}{a partial least square discriminant analysis based model, built
by mixOmics package.}

\item{mod_time}{modulation time of the second dimension}

\item{time_range}{an atomic vector of lenght two with the time range
of chromatographic  run.}

\item{sampling_rt}{the sampling rate of the equipment.}
}
\description{
`import_mixOmics` transform a mixOmics discriminant analysis
  eigenvalues/eigenvectors into a familiar structure to be handled in the
  RGCxGC package.
}
\details{
This function takes a model built through
  \code{\link[mixOmics]{plsda}} and \code{\link[mixOmics]{splsda}}, then,
  access to loading values and transform each dimension loading into
  a two-dimensional matrix. This matrix represents a typcial GCxGC
  chromatogram. By default, user can provide a chromatogram where the
  requiered information will be retrieved from. On the other hand,
  user can also provide all the needed information
  (\emph{mod_time}, \emph{time_range}, \emph{sampling_rt})
  to fold eigenvectors into a typical GCxGC chromatogram.
}
\examples{
\donttest{

#### Preparing data ####
# Load libraries
library(mixOmics)
library(caret)
# Load chromatograms
data(Myrothecium)

# Unfold chromatograms
list_chrom <- unfold_chrom(Myrothecium)
unfolded_chrom <- list_chrom$chromatogram
colnames(unfolded_chrom) <- paste0("RT", seq(dim(unfolded_chrom)[2]))
metadata <- get_metadata(Myrothecium)

index <- get_metadata(Myrothecium)
# Create a response variable
Y <- factor(index$Type)

#### Build the PLS-DA model ####
# For reprosucibility
set.seed(10)
chrom_dim <- dim(unfolded_chrom)[2]
list.keepX <- seq(chrom_dim/3, chrom_dim, by = 5000)
tune.splsda <- tune.splsda(unfolded_chrom, Y, ncomp = 2, validation = 'loo',
                          progressBar = TRUE, dist = 'max.dist',
                          cpus = 1, # Set cpus according with your pc
                          test.keepX = list.keepX)
# Number of variables per component
tune.splsda$choice.keepX
# Remove zero variance predictor variables
zero_var <- caret::nearZeroVar(unfolded_chrom)
unfolded_chrom <- unfolded_chrom[, -zero_var]
splsda_final <- mixOmics::splsda(unfolded_chrom, Y,
                                 ncomp = 2, keepX = list.keepX)
# Scores
scores <- as.data.frame(splsda_final$variates$X)
scores$Names <- rownames(scores)
scores <- merge(scores, metadata)
xyplot(comp2 ~ comp1, data = scores, groups = Type, pch = c(8, 1), cex = 2)
}
}
